<?php
/**
 * install wizard
 * 
 * @package Sngine
 * @author Zamblek
 */

// set system name & version
define('SYS_NAME', 'Sngine');
define('SYS_VER', '3.2.1');


// set absolut & base path
define('ABSPATH',dirname(__FILE__).'/');
define('BASEPATH',dirname($_SERVER['PHP_SELF']));


// check the config file
if(file_exists(ABSPATH.'includes/config.php')) {
    /* the config file exist -> start the system */
    header('Location: ./');
}


// enviroment settings
error_reporting(E_ALL ^ (E_NOTICE | E_WARNING));


// get functions
require(ABSPATH.'includes/functions.php');


// check system requirements
$requirements_errors = check_system_requirements();


// install
if(isset($_POST['submit'])) {
    
    // double check system requirements
    if($requirements_errors) {
      _error("Error", "You need to check the system requirements to continue, Back to your hosting support for help.");
    }


    // check valid purchase code
    try {
        $licence_key = get_licence_key($_POST['purchase_code']);
        if(is_empty($_POST['purchase_code']) || $licence_key === false) {
            _error("Error", "Please enter a valid purchase code");
        }
        $session_hash = $licence_key;
    } catch (Exception $e) {
        _error("Error", $e->getMessage());
    }
    
    
    // connect to the db
    $db = new mysqli($_POST['db_host'], $_POST['db_username'], $_POST['db_password'], $_POST['db_name'], $_POST['db_port']);
    if(mysqli_connect_error()) {
        _error(DB_ERROR);
    }


    // check admin data
    /* check email */
    if(!valid_email($_POST['admin_email'])) {
        _error("Error", "Please enter a valid email address");
    }
    /* check username */
    if(!valid_username($_POST['admin_username'])) {
        _error("Error", "Please enter a valid username (a-z0-9_.) with minimum 3 characters long");
    }
    if(reserved_username($_POST['admin_username'])) {
        _error("Error", "You can't use"." <strong>".$_POST['admin_username']."</strong> "."as username");
    }
    /* check password */
    if(is_empty($_POST['admin_password']) || strlen($_POST['admin_password']) < 6) {
        _error("Error", "Your password must be at least 6 characters long. Please try another");
    }


    // create the database
    $structure = "

--
-- Database: `sngine`
--

-- --------------------------------------------------------

--
-- Table structure for table `ads_campaigns`
--

DROP TABLE IF EXISTS `ads_campaigns`;
CREATE TABLE IF NOT EXISTS `ads_campaigns` (
  `campaign_id` int(10) NOT NULL AUTO_INCREMENT,
  `campaign_user_id` int(10) UNSIGNED NOT NULL,
  `campaign_title` varchar(256) NOT NULL,
  `campaign_start_date` datetime NOT NULL,
  `campaign_end_date` datetime NOT NULL,
  `campaign_budget` double NOT NULL,
  `campaign_spend` double NOT NULL DEFAULT '0',
  `campaign_bidding` enum('click','view') NOT NULL,
  `audience_countries` mediumtext NOT NULL,
  `audience_gender` varchar(32) NOT NULL,
  `audience_relationship` varchar(64) NOT NULL,
  `ads_title` varchar(255) DEFAULT NULL,
  `ads_description` mediumtext,
  `ads_type` varchar(32) NOT NULL,
  `ads_url` varchar(256) DEFAULT NULL,
  `ads_page` int(10) UNSIGNED DEFAULT NULL,
  `ads_group` int(10) UNSIGNED DEFAULT NULL,
  `ads_event` int(10) UNSIGNED DEFAULT NULL,
  `ads_placement` enum('newsfeed','sidebar') NOT NULL,
  `ads_image` varchar(256) NOT NULL,
  `campaign_created_date` datetime NOT NULL,
  `campaign_is_active` enum('0','1') NOT NULL DEFAULT '1',
  `campaign_views` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `campaign_clicks` int(10) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`campaign_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `ads_system`
--

DROP TABLE IF EXISTS `ads_system`;
CREATE TABLE IF NOT EXISTS `ads_system` (
  `ads_id` int(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(256) NOT NULL,
  `place` varchar(32) NOT NULL,
  `code` mediumtext NOT NULL,
  `time` datetime NOT NULL,
  PRIMARY KEY (`ads_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `affiliates_payments`
--

DROP TABLE IF EXISTS `affiliates_payments`;
CREATE TABLE IF NOT EXISTS `affiliates_payments` (
  `payment_id` int(10) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) UNSIGNED NOT NULL,
  `amount` varchar(32) NOT NULL,
  `method` varchar(64) NOT NULL,
  `method_value` text NOT NULL,
  `time` datetime NOT NULL,
  `status` tinyint(1) NOT NULL,
  PRIMARY KEY (`payment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `announcements`
--

DROP TABLE IF EXISTS `announcements`;
CREATE TABLE IF NOT EXISTS `announcements` (
  `announcement_id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(256) NOT NULL,
  `title` varchar(256) NOT NULL,
  `type` varchar(32) NOT NULL,
  `code` mediumtext NOT NULL,
  `start_date` datetime NOT NULL,
  `end_date` datetime NOT NULL,
  PRIMARY KEY (`announcement_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `announcements_users`
--

DROP TABLE IF EXISTS `announcements_users`;
CREATE TABLE IF NOT EXISTS `announcements_users` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `announcement_id` int(10) UNSIGNED NOT NULL,
  `user_id` int(10) UNSIGNED NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `announcement_id_user_id` (`announcement_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `bank_transfers`
--

DROP TABLE IF EXISTS `bank_transfers`;
CREATE TABLE IF NOT EXISTS `bank_transfers` (
  `transfer_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` int(10) UNSIGNED NOT NULL,
  `handle` varchar(32) NOT NULL,
  `package_id` int(10) UNSIGNED DEFAULT NULL,
  `post_id` int(10) UNSIGNED DEFAULT NULL,
  `price` varchar(32) DEFAULT NULL,
  `bank_receipt` varchar(256) NOT NULL,
  `time` datetime NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`transfer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `blacklist`
--

DROP TABLE IF EXISTS `blacklist`;
CREATE TABLE IF NOT EXISTS `blacklist` (
  `node_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `node_type` enum('ip','email','username') NOT NULL,
  `node_value` varchar(64) NOT NULL,
  `created_time` datetime NOT NULL,
  PRIMARY KEY (`node_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `blogs_categories`
--

DROP TABLE IF EXISTS `blogs_categories`;
CREATE TABLE IF NOT EXISTS `blogs_categories` (
  `category_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `category_parent_id` int(10) UNSIGNED NOT NULL,
  `category_name` varchar(256) NOT NULL,
  `category_description` text NOT NULL,
  `category_order` int(10) UNSIGNED NOT NULL DEFAULT '1',
  PRIMARY KEY (`category_id`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `blogs_categories`
--

INSERT INTO `blogs_categories` (`category_id`, `category_parent_id`, `category_name`, `category_description`, `category_order`) VALUES
(1, 0, 'Art', '', 1),
(2, 0, 'Causes', '', 2),
(3, 0, 'Crafts', '', 3),
(4, 0, 'Dance', '', 4),
(5, 0, 'Drinks', '', 5),
(6, 0, 'Film', '', 6),
(7, 0, 'Fitness', '', 7),
(8, 0, 'Food', '', 8),
(9, 0, 'Games', '', 9),
(10, 0, 'Gardening', '', 10),
(11, 0, 'Health', '', 11),
(12, 0, 'Home', '', 12),
(13, 0, 'Literature', '', 13),
(14, 0, 'Music', '', 14),
(15, 0, 'Networking', '', 15),
(16, 0, 'Other', '', 16),
(17, 0, 'Party', '', 17),
(18, 0, 'Religion', '', 18),
(19, 0, 'Shopping', '', 19),
(20, 0, 'Sports', '', 20),
(21, 0, 'Theater', '', 21),
(22, 0, 'Wellness', '', 22);

-- --------------------------------------------------------

--
-- Table structure for table `coinpayments_transactions`
--

DROP TABLE IF EXISTS `coinpayments_transactions`;
CREATE TABLE IF NOT EXISTS `coinpayments_transactions` (
  `transaction_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `transaction_txn_id` text,
  `user_id` int(10) UNSIGNED NOT NULL,
  `amount` varchar(32) NOT NULL,
  `product` text NOT NULL,
  `created_at` datetime NOT NULL,
  `last_update` datetime NOT NULL,
  `status` tinyint(1) UNSIGNED NOT NULL,
  `status_message` text,
  PRIMARY KEY (`transaction_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `conversations`
--

DROP TABLE IF EXISTS `conversations`;
CREATE TABLE IF NOT EXISTS `conversations` (
  `conversation_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `last_message_id` int(10) UNSIGNED NOT NULL,
  `color` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`conversation_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `conversations_calls_audio`
--

DROP TABLE IF EXISTS `conversations_calls_audio`;
CREATE TABLE IF NOT EXISTS `conversations_calls_audio` (
  `call_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `from_user_id` int(10) UNSIGNED NOT NULL,
  `from_user_token` mediumtext NOT NULL,
  `to_user_id` int(10) UNSIGNED NOT NULL,
  `to_user_token` mediumtext NOT NULL,
  `room` varchar(64) NOT NULL,
  `answered` enum('0','1') NOT NULL DEFAULT '0',
  `declined` enum('0','1') NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL,
  `updated_time` datetime NOT NULL,
  PRIMARY KEY (`call_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `conversations_calls_video`
--

DROP TABLE IF EXISTS `conversations_calls_video`;
CREATE TABLE IF NOT EXISTS `conversations_calls_video` (
  `call_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `from_user_id` int(10) UNSIGNED NOT NULL,
  `from_user_token` text NOT NULL,
  `to_user_id` int(10) UNSIGNED NOT NULL,
  `to_user_token` text NOT NULL,
  `room` varchar(64) NOT NULL,
  `answered` enum('0','1') NOT NULL DEFAULT '0',
  `declined` enum('0','1') NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL,
  `updated_time` datetime NOT NULL,
  PRIMARY KEY (`call_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `conversations_messages`
--

DROP TABLE IF EXISTS `conversations_messages`;
CREATE TABLE IF NOT EXISTS `conversations_messages` (
  `message_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `conversation_id` int(10) UNSIGNED NOT NULL,
  `user_id` int(10) UNSIGNED NOT NULL,
  `message` longtext NOT NULL,
  `image` varchar(256) NOT NULL,
  `voice_note` varchar(256) NOT NULL,
  `time` datetime NOT NULL,
  PRIMARY KEY (`message_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `conversations_users`
--

DROP TABLE IF EXISTS `conversations_users`;
CREATE TABLE IF NOT EXISTS `conversations_users` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `conversation_id` int(10) UNSIGNED NOT NULL,
  `user_id` int(10) UNSIGNED NOT NULL,
  `seen` enum('0','1') NOT NULL DEFAULT '0',
  `typing` enum('0','1') NOT NULL DEFAULT '0',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `conversation_id_user_id` (`conversation_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `custom_fields`
--

DROP TABLE IF EXISTS `custom_fields`;
CREATE TABLE IF NOT EXISTS `custom_fields` (
  `field_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `field_for` enum('user','page','group','event') NOT NULL DEFAULT 'user',
  `type` varchar(32) NOT NULL,
  `select_options` mediumtext NOT NULL,
  `label` varchar(256) NOT NULL,
  `description` mediumtext NOT NULL,
  `place` varchar(32) NOT NULL,
  `length` int(10) NOT NULL DEFAULT '32',
  `field_order` int(10) NOT NULL DEFAULT '1',
  `is_link` enum('0','1') NOT NULL DEFAULT '0',
  `mandatory` enum('0','1') NOT NULL DEFAULT '0',
  `in_registration` enum('0','1') NOT NULL DEFAULT '0',
  `in_profile` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`field_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `custom_fields_values`
--

DROP TABLE IF EXISTS `custom_fields_values`;
CREATE TABLE IF NOT EXISTS `custom_fields_values` (
  `value_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `value` mediumtext NOT NULL,
  `field_id` int(10) UNSIGNED NOT NULL,
  `node_id` int(10) UNSIGNED NOT NULL,
  `node_type` enum('user','page','group','event') NOT NULL,
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `field_id_node_id_node_type` (`field_id`,`node_id`,`node_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `developers_apps`
--

DROP TABLE IF EXISTS `developers_apps`;
CREATE TABLE IF NOT EXISTS `developers_apps` (
  `app_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `app_user_id` int(10) UNSIGNED NOT NULL,
  `app_category_id` int(10) UNSIGNED NOT NULL,
  `app_auth_id` varchar(128) NOT NULL,
  `app_auth_secret` varchar(128) NOT NULL,
  `app_name` varchar(256) NOT NULL,
  `app_domain` varchar(256) NOT NULL,
  `app_redirect_url` varchar(256) NOT NULL,
  `app_description` mediumtext NOT NULL,
  `app_icon` varchar(256) NOT NULL,
  `app_date` datetime NOT NULL,
  PRIMARY KEY (`app_id`),
  UNIQUE KEY `app_auth_id` (`app_auth_id`),
  UNIQUE KEY `app_auth_secret` (`app_auth_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `developers_apps_categories`
--

DROP TABLE IF EXISTS `developers_apps_categories`;
CREATE TABLE IF NOT EXISTS `developers_apps_categories` (
  `category_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `category_parent_id` int(10) UNSIGNED NOT NULL,
  `category_name` varchar(256) NOT NULL,
  `category_description` text NOT NULL,
  `category_order` int(10) UNSIGNED NOT NULL DEFAULT '1',
  PRIMARY KEY (`category_id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `developers_apps_categories`
--

INSERT INTO `developers_apps_categories` (`category_id`, `category_parent_id`, `category_name`, `category_description`, `category_order`) VALUES
(1, 0, 'Business and Pages', '', 1),
(2, 0, 'Community &amp; Government', '', 2),
(3, 0, 'Education', '', 3),
(4, 0, 'Entertainment', '', 4),
(5, 0, 'Entertainment', '', 5),
(6, 0, 'Games', '', 6),
(7, 0, 'Lifestyle', '', 7),
(8, 0, 'Messaging', '', 8),
(9, 0, 'News', '', 9),
(10, 0, 'Shopping', '', 10),
(11, 0, 'Social Networks &amp; Dating', '', 11),
(12, 0, 'Utility &amp; Productivity', '', 12);

-- --------------------------------------------------------

--
-- Table structure for table `developers_apps_users`
--

DROP TABLE IF EXISTS `developers_apps_users`;
CREATE TABLE IF NOT EXISTS `developers_apps_users` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `app_id` int(10) UNSIGNED NOT NULL,
  `user_id` int(10) UNSIGNED NOT NULL,
  `auth_key` varchar(128) NOT NULL,
  `access_token` varchar(128) DEFAULT NULL,
  `access_token_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `page_id_user_id` (`app_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `emojis`
--

DROP TABLE IF EXISTS `emojis`;
CREATE TABLE IF NOT EXISTS `emojis` (
  `emoji_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `pattern` varchar(256) NOT NULL,
  `class` varchar(256) NOT NULL,
  PRIMARY KEY (`emoji_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3508 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `emojis`
--

INSERT INTO `emojis` (`emoji_id`, `pattern`, `class`) VALUES
(1, ':grinning-face:', 'grinning-face'),
(2, ':grinning-face-with-big-eyes:', 'grinning-face-with-big-eyes'),
(3, ':grinning-face-with-smiling-eyes:', 'grinning-face-with-smiling-eyes'),
(4, ':beaming-face-with-smiling-eyes:', 'beaming-face-with-smiling-eyes'),
(5, ':grinning-squinting-face:', 'grinning-squinting-face'),
(6, ':grinning-face-with-sweat:', 'grinning-face-with-sweat'),
(7, ':rolling-on-the-floor-laughing:', 'rolling-on-the-floor-laughing'),
(8, ':face-with-tears-of-joy:', 'face-with-tears-of-joy'),
(9, ':slightly-smiling-face:', 'slightly-smiling-face'),
(10, ':upside-down-face:', 'upside-down-face'),
(11, ':winking-face:', 'winking-face'),
(12, ':smiling-face-with-smiling-eyes:', 'smiling-face-with-smiling-eyes'),
(13, ':smiling-face-with-halo:', 'smiling-face-with-halo'),
(14, ':smiling-face-with-hearts:', 'smiling-face-with-hearts'),
(15, ':smiling-face-with-heart-eyes:', 'smiling-face-with-heart-eyes'),
(16, ':star-struck:', 'star-struck'),
(17, ':face-blowing-a-kiss:', 'face-blowing-a-kiss'),
(18, ':kissing-face:', 'kissing-face'),
(19, ':smiling-face:', 'smiling-face'),
(20, ':kissing-face-with-closed-eyes:', 'kissing-face-with-closed-eyes'),
(21, ':kissing-face-with-smiling-eyes:', 'kissing-face-with-smiling-eyes'),
(22, ':smiling-face-with-tear:', 'smiling-face-with-tear'),
(23, ':face-savoring-food:', 'face-savoring-food'),
(24, ':face-with-tongue:', 'face-with-tongue'),
(25, ':winking-face-with-tongue:', 'winking-face-with-tongue'),
(26, ':zany-face:', 'zany-face'),
(27, ':squinting-face-with-tongue:', 'squinting-face-with-tongue'),
(28, ':money-mouth-face:', 'money-mouth-face'),
(29, ':hugging-face:', 'hugging-face'),
(30, ':face-with-hand-over-mouth:', 'face-with-hand-over-mouth'),
(31, ':shushing-face:', 'shushing-face'),
(32, ':thinking-face:', 'thinking-face'),
(33, ':zipper-mouth-face:', 'zipper-mouth-face'),
(34, ':face-with-raised-eyebrow:', 'face-with-raised-eyebrow'),
(35, ':neutral-face:', 'neutral-face'),
(36, ':expressionless-face:', 'expressionless-face'),
(37, ':face-without-mouth:', 'face-without-mouth'),
(38, ':face-in-clouds:', 'face-in-clouds'),
(39, ':smirking-face:', 'smirking-face'),
(40, ':unamused-face:', 'unamused-face'),
(41, ':face-with-rolling-eyes:', 'face-with-rolling-eyes'),
(42, ':grimacing-face:', 'grimacing-face'),
(43, ':face-exhaling:', 'face-exhaling'),
(44, ':lying-face:', 'lying-face'),
(45, ':relieved-face:', 'relieved-face'),
(46, ':pensive-face:', 'pensive-face'),
(47, ':sleepy-face:', 'sleepy-face'),
(48, ':drooling-face:', 'drooling-face'),
(49, ':sleeping-face:', 'sleeping-face'),
(50, ':face-with-medical-mask:', 'face-with-medical-mask'),
(51, ':face-with-thermometer:', 'face-with-thermometer'),
(52, ':face-with-head-bandage:', 'face-with-head-bandage'),
(53, ':nauseated-face:', 'nauseated-face'),
(54, ':face-vomiting:', 'face-vomiting'),
(55, ':sneezing-face:', 'sneezing-face'),
(56, ':hot-face:', 'hot-face'),
(57, ':cold-face:', 'cold-face'),
(58, ':woozy-face:', 'woozy-face'),
(59, ':knocked-out-face:', 'knocked-out-face'),
(60, ':face-with-spiral-eyes:', 'face-with-spiral-eyes'),
(61, ':exploding-head:', 'exploding-head'),
(62, ':cowboy-hat-face:', 'cowboy-hat-face'),
(63, ':partying-face:', 'partying-face'),
(64, ':disguised-face:', 'disguised-face'),
(65, ':smiling-face-with-sunglasses:', 'smiling-face-with-sunglasses'),
(66, ':nerd-face:', 'nerd-face'),
(67, ':face-with-monocle:', 'face-with-monocle'),
(68, ':confused-face:', 'confused-face'),
(69, ':worried-face:', 'worried-face'),
(70, ':slightly-frowning-face:', 'slightly-frowning-face'),
(71, ':frowning-face:', 'frowning-face'),
(72, ':face-with-open-mouth:', 'face-with-open-mouth'),
(73, ':hushed-face:', 'hushed-face'),
(74, ':astonished-face:', 'astonished-face'),
(75, ':flushed-face:', 'flushed-face'),
(76, ':pleading-face:', 'pleading-face'),
(77, ':frowning-face-with-open-mouth:', 'frowning-face-with-open-mouth'),
(78, ':anguished-face:', 'anguished-face'),
(79, ':fearful-face:', 'fearful-face'),
(80, ':anxious-face-with-sweat:', 'anxious-face-with-sweat'),
(81, ':sad-but-relieved-face:', 'sad-but-relieved-face'),
(82, ':crying-face:', 'crying-face'),
(83, ':loudly-crying-face:', 'loudly-crying-face'),
(84, ':face-screaming-in-fear:', 'face-screaming-in-fear'),
(85, ':confounded-face:', 'confounded-face'),
(86, ':persevering-face:', 'persevering-face'),
(87, ':disappointed-face:', 'disappointed-face'),
(88, ':downcast-face-with-sweat:', 'downcast-face-with-sweat'),
(89, ':weary-face:', 'weary-face'),
(90, ':tired-face:', 'tired-face'),
(91, ':yawning-face:', 'yawning-face'),
(92, ':face-with-steam-from-nose:', 'face-with-steam-from-nose'),
(93, ':pouting-face:', 'pouting-face'),
(94, ':angry-face:', 'angry-face'),
(95, ':face-with-symbols-on-mouth:', 'face-with-symbols-on-mouth'),
(96, ':smiling-face-with-horns:', 'smiling-face-with-horns'),
(97, ':angry-face-with-horns:', 'angry-face-with-horns'),
(98, ':skull:', 'skull'),
(99, ':skull-and-crossbones:', 'skull-and-crossbones'),
(100, ':pile-of-poo:', 'pile-of-poo'),
(101, ':clown-face:', 'clown-face'),
(102, ':ogre:', 'ogre'),
(103, ':goblin:', 'goblin'),
(104, ':ghost:', 'ghost'),
(105, ':alien:', 'alien'),
(106, ':alien-monster:', 'alien-monster'),
(107, ':robot:', 'robot'),
(108, ':grinning-cat:', 'grinning-cat'),
(109, ':grinning-cat-with-smiling-eyes:', 'grinning-cat-with-smiling-eyes'),
(110, ':cat-with-tears-of-joy:', 'cat-with-tears-of-joy'),
(111, ':smiling-cat-with-heart-eyes:', 'smiling-cat-with-heart-eyes'),
(112, ':cat-with-wry-smile:', 'cat-with-wry-smile'),
(113, ':kissing-cat:', 'kissing-cat'),
(114, ':weary-cat:', 'weary-cat'),
(115, ':crying-cat:', 'crying-cat'),
(116, ':pouting-cat:', 'pouting-cat'),
(117, ':see-no-evil-monkey:', 'see-no-evil-monkey'),
(118, ':hear-no-evil-monkey:', 'hear-no-evil-monkey'),
(119, ':speak-no-evil-monkey:', 'speak-no-evil-monkey'),
(120, ':kiss-mark:', 'kiss-mark'),
(121, ':love-letter:', 'love-letter'),
(122, ':heart-with-arrow:', 'heart-with-arrow'),
(123, ':heart-with-ribbon:', 'heart-with-ribbon'),
(124, ':sparkling-heart:', 'sparkling-heart'),
(125, ':growing-heart:', 'growing-heart'),
(126, ':beating-heart:', 'beating-heart'),
(127, ':revolving-hearts:', 'revolving-hearts'),
(128, ':two-hearts:', 'two-hearts'),
(129, ':heart-decoration:', 'heart-decoration'),
(130, ':heart-exclamation:', 'heart-exclamation'),
(131, ':broken-heart:', 'broken-heart'),
(132, ':heart-on-fire:', 'heart-on-fire'),
(133, ':mending-heart:', 'mending-heart'),
(134, ':red-heart:', 'red-heart'),
(135, ':orange-heart:', 'orange-heart'),
(136, ':yellow-heart:', 'yellow-heart'),
(137, ':green-heart:', 'green-heart'),
(138, ':blue-heart:', 'blue-heart'),
(139, ':purple-heart:', 'purple-heart'),
(140, ':brown-heart:', 'brown-heart'),
(141, ':black-heart:', 'black-heart'),
(142, ':white-heart:', 'white-heart'),
(143, ':hundred-points:', 'hundred-points'),
(144, ':anger-symbol:', 'anger-symbol'),
(145, ':collision:', 'collision'),
(146, ':dizzy:', 'dizzy'),
(147, ':sweat-droplets:', 'sweat-droplets'),
(148, ':dashing-away:', 'dashing-away'),
(149, ':hole:', 'hole'),
(150, ':bomb:', 'bomb'),
(151, ':speech-balloon:', 'speech-balloon'),
(152, ':eye-in-speech-bubble:', 'eye-in-speech-bubble'),
(153, ':left-speech-bubble:', 'left-speech-bubble'),
(154, ':right-anger-bubble:', 'right-anger-bubble'),
(155, ':thought-balloon:', 'thought-balloon'),
(156, ':zzz:', 'zzz'),
(157, ':waving-hand:', 'waving-hand'),
(158, ':raised-back-of-hand:', 'raised-back-of-hand'),
(159, ':hand-with-fingers-splayed:', 'hand-with-fingers-splayed'),
(160, ':raised-hand:', 'raised-hand'),
(161, ':vulcan-salute:', 'vulcan-salute'),
(162, ':ok-hand:', 'ok-hand'),
(163, ':pinched-fingers:', 'pinched-fingers'),
(164, ':pinching-hand:', 'pinching-hand'),
(165, ':victory-hand:', 'victory-hand'),
(166, ':crossed-fingers:', 'crossed-fingers'),
(167, ':love-you-gesture:', 'love-you-gesture'),
(168, ':sign-of-the-horns:', 'sign-of-the-horns'),
(169, ':call-me-hand:', 'call-me-hand'),
(170, ':backhand-index-pointing-left:', 'backhand-index-pointing-left'),
(171, ':backhand-index-pointing-right:', 'backhand-index-pointing-right'),
(172, ':backhand-index-pointing-up:', 'backhand-index-pointing-up'),
(173, ':middle-finger:', 'middle-finger'),
(174, ':backhand-index-pointing-down:', 'backhand-index-pointing-down'),
(175, ':index-pointing-up:', 'index-pointing-up'),
(176, ':thumbs-up:', 'thumbs-up'),
(177, ':thumbs-down:', 'thumbs-down'),
(178, ':raised-fist:', 'raised-fist'),
(179, ':oncoming-fist:', 'oncoming-fist'),
(180, ':left-facing-fist:', 'left-facing-fist'),
(181, ':right-facing-fist:', 'right-facing-fist'),
(182, ':clapping-hands:', 'clapping-hands'),
(183, ':raising-hands:', 'raising-hands'),
(184, ':open-hands:', 'open-hands'),
(185, ':palms-up-together:', 'palms-up-together'),
(186, ':handshake:', 'handshake'),
(187, ':folded-hands:', 'folded-hands'),
(188, ':writing-hand:', 'writing-hand'),
(189, ':nail-polish:', 'nail-polish'),
(190, ':selfie:', 'selfie'),
(191, ':flexed-biceps:', 'flexed-biceps'),
(192, ':mechanical-arm:', 'mechanical-arm'),
(193, ':mechanical-leg:', 'mechanical-leg'),
(194, ':leg:', 'leg'),
(195, ':foot:', 'foot'),
(196, ':ear:', 'ear'),
(197, ':ear-with-hearing-aid:', 'ear-with-hearing-aid'),
(198, ':nose:', 'nose'),
(199, ':brain:', 'brain'),
(200, ':anatomical-heart:', 'anatomical-heart'),
(201, ':lungs:', 'lungs'),
(202, ':tooth:', 'tooth'),
(203, ':bone:', 'bone'),
(204, ':eyes:', 'eyes'),
(205, ':eye:', 'eye'),
(206, ':tongue:', 'tongue'),
(207, ':mouth:', 'mouth'),
(208, ':baby:', 'baby'),
(209, ':child:', 'child'),
(210, ':boy:', 'boy'),
(211, ':girl:', 'girl'),
(212, ':person:', 'person'),
(213, ':person-blond-hair:', 'person-blond-hair'),
(214, ':man:', 'man'),
(215, ':person-beard:', 'person-beard'),
(216, ':man-beard:', 'man-beard'),
(217, ':woman-beard:', 'woman-beard'),
(218, ':man-red-hair:', 'man-red-hair'),
(219, ':man-curly-hair:', 'man-curly-hair'),
(220, ':man-white-hair:', 'man-white-hair'),
(221, ':man-bald:', 'man-bald'),
(222, ':woman:', 'woman'),
(223, ':woman-red-hair:', 'woman-red-hair'),
(224, ':person-red-hair:', 'person-red-hair'),
(225, ':woman-curly-hair:', 'woman-curly-hair'),
(226, ':person-curly-hair:', 'person-curly-hair'),
(227, ':woman-white-hair:', 'woman-white-hair'),
(228, ':person-white-hair:', 'person-white-hair'),
(229, ':woman-bald:', 'woman-bald'),
(230, ':person-bald:', 'person-bald'),
(231, ':woman-blond-hair:', 'woman-blond-hair'),
(232, ':man-blond-hair:', 'man-blond-hair'),
(233, ':older-person:', 'older-person'),
(234, ':old-man:', 'old-man'),
(235, ':old-woman:', 'old-woman'),
(236, ':person-frowning:', 'person-frowning'),
(237, ':man-frowning:', 'man-frowning'),
(238, ':woman-frowning:', 'woman-frowning'),
(239, ':person-pouting:', 'person-pouting'),
(240, ':man-pouting:', 'man-pouting'),
(241, ':woman-pouting:', 'woman-pouting'),
(242, ':person-gesturing-no:', 'person-gesturing-no'),
(243, ':man-gesturing-no:', 'man-gesturing-no'),
(244, ':woman-gesturing-no:', 'woman-gesturing-no'),
(245, ':person-gesturing-ok:', 'person-gesturing-ok'),
(246, ':man-gesturing-ok:', 'man-gesturing-ok'),
(247, ':woman-gesturing-ok:', 'woman-gesturing-ok'),
(248, ':person-tipping-hand:', 'person-tipping-hand'),
(249, ':man-tipping-hand:', 'man-tipping-hand'),
(250, ':woman-tipping-hand:', 'woman-tipping-hand'),
(251, ':person-raising-hand:', 'person-raising-hand'),
(252, ':man-raising-hand:', 'man-raising-hand'),
(253, ':woman-raising-hand:', 'woman-raising-hand'),
(254, ':deaf-person:', 'deaf-person'),
(255, ':deaf-man:', 'deaf-man'),
(256, ':deaf-woman:', 'deaf-woman'),
(257, ':person-bowing:', 'person-bowing'),
(258, ':man-bowing:', 'man-bowing'),
(259, ':woman-bowing:', 'woman-bowing'),
(260, ':person-facepalming:', 'person-facepalming'),
(261, ':man-facepalming:', 'man-facepalming'),
(262, ':woman-facepalming:', 'woman-facepalming'),
(263, ':person-shrugging:', 'person-shrugging'),
(264, ':man-shrugging:', 'man-shrugging'),
(265, ':woman-shrugging:', 'woman-shrugging'),
(266, ':health-worker:', 'health-worker'),
(267, ':man-health-worker:', 'man-health-worker'),
(268, ':woman-health-worker:', 'woman-health-worker'),
(269, ':student:', 'student'),
(270, ':man-student:', 'man-student'),
(271, ':woman-student:', 'woman-student'),
(272, ':teacher:', 'teacher'),
(273, ':man-teacher:', 'man-teacher'),
(274, ':woman-teacher:', 'woman-teacher'),
(275, ':judge:', 'judge'),
(276, ':man-judge:', 'man-judge'),
(277, ':woman-judge:', 'woman-judge'),
(278, ':farmer:', 'farmer'),
(279, ':man-farmer:', 'man-farmer'),
(280, ':woman-farmer:', 'woman-farmer'),
(281, ':cook:', 'cook'),
(282, ':man-cook:', 'man-cook'),
(283, ':woman-cook:', 'woman-cook'),
(284, ':mechanic:', 'mechanic'),
(285, ':man-mechanic:', 'man-mechanic'),
(286, ':woman-mechanic:', 'woman-mechanic'),
(287, ':factory-worker:', 'factory-worker'),
(288, ':man-factory-worker:', 'man-factory-worker'),
(289, ':woman-factory-worker:', 'woman-factory-worker'),
(290, ':office-worker:', 'office-worker'),
(291, ':man-office-worker:', 'man-office-worker'),
(292, ':woman-office-worker:', 'woman-office-worker'),
(293, ':scientist:', 'scientist'),
(294, ':man-scientist:', 'man-scientist'),
(295, ':woman-scientist:', 'woman-scientist'),
(296, ':technologist:', 'technologist'),
(297, ':man-technologist:', 'man-technologist'),
(298, ':woman-technologist:', 'woman-technologist'),
(299, ':singer:', 'singer'),
(300, ':man-singer:', 'man-singer'),
(301, ':woman-singer:', 'woman-singer'),
(302, ':artist:', 'artist'),
(303, ':man-artist:', 'man-artist'),
(304, ':woman-artist:', 'woman-artist'),
(305, ':pilot:', 'pilot'),
(306, ':man-pilot:', 'man-pilot'),
(307, ':woman-pilot:', 'woman-pilot'),
(308, ':astronaut:', 'astronaut'),
(309, ':man-astronaut:', 'man-astronaut'),
(310, ':woman-astronaut:', 'woman-astronaut'),
(311, ':firefighter:', 'firefighter'),
(312, ':man-firefighter:', 'man-firefighter'),
(313, ':woman-firefighter:', 'woman-firefighter'),
(314, ':police-officer:', 'police-officer'),
(315, ':man-police-officer:', 'man-police-officer'),
(316, ':woman-police-officer:', 'woman-police-officer'),
(317, ':detective:', 'detective'),
(318, ':man-detective:', 'man-detective'),
(319, ':woman-detective:', 'woman-detective'),
(320, ':guard:', 'guard'),
(321, ':man-guard:', 'man-guard'),
(322, ':woman-guard:', 'woman-guard'),
(323, ':ninja:', 'ninja'),
(324, ':construction-worker:', 'construction-worker'),
(325, ':man-construction-worker:', 'man-construction-worker'),
(326, ':woman-construction-worker:', 'woman-construction-worker'),
(327, ':prince:', 'prince'),
(328, ':princess:', 'princess'),
(329, ':person-wearing-turban:', 'person-wearing-turban'),
(330, ':man-wearing-turban:', 'man-wearing-turban'),
(331, ':woman-wearing-turban:', 'woman-wearing-turban'),
(332, ':person-with-skullcap:', 'person-with-skullcap'),
(333, ':woman-with-headscarf:', 'woman-with-headscarf'),
(334, ':person-in-tuxedo:', 'person-in-tuxedo'),
(335, ':man-in-tuxedo:', 'man-in-tuxedo'),
(336, ':woman-in-tuxedo:', 'woman-in-tuxedo'),
(337, ':person-with-veil:', 'person-with-veil'),
(338, ':man-with-veil:', 'man-with-veil'),
(339, ':woman-with-veil:', 'woman-with-veil'),
(340, ':pregnant-woman:', 'pregnant-woman'),
(341, ':breast-feeding:', 'breast-feeding'),
(342, ':woman-feeding-baby:', 'woman-feeding-baby'),
(343, ':man-feeding-baby:', 'man-feeding-baby'),
(344, ':person-feeding-baby:', 'person-feeding-baby'),
(345, ':baby-angel:', 'baby-angel'),
(346, ':santa-claus:', 'santa-claus'),
(347, ':mrsclaus:', 'mrsclaus'),
(348, ':mx-claus:', 'mx-claus'),
(349, ':superhero:', 'superhero'),
(350, ':man-superhero:', 'man-superhero'),
(351, ':woman-superhero:', 'woman-superhero'),
(352, ':supervillain:', 'supervillain'),
(353, ':man-supervillain:', 'man-supervillain'),
(354, ':woman-supervillain:', 'woman-supervillain'),
(355, ':mage:', 'mage'),
(356, ':man-mage:', 'man-mage'),
(357, ':woman-mage:', 'woman-mage'),
(358, ':fairy:', 'fairy'),
(359, ':man-fairy:', 'man-fairy'),
(360, ':woman-fairy:', 'woman-fairy'),
(361, ':vampire:', 'vampire'),
(362, ':man-vampire:', 'man-vampire'),
(363, ':woman-vampire:', 'woman-vampire'),
(364, ':merperson:', 'merperson'),
(365, ':merman:', 'merman'),
(366, ':mermaid:', 'mermaid'),
(367, ':elf:', 'elf'),
(368, ':man-elf:', 'man-elf'),
(369, ':woman-elf:', 'woman-elf'),
(370, ':genie:', 'genie'),
(371, ':man-genie:', 'man-genie'),
(372, ':woman-genie:', 'woman-genie'),
(373, ':zombie:', 'zombie'),
(374, ':man-zombie:', 'man-zombie'),
(375, ':woman-zombie:', 'woman-zombie'),
(376, ':person-getting-massage:', 'person-getting-massage'),
(377, ':man-getting-massage:', 'man-getting-massage'),
(378, ':woman-getting-massage:', 'woman-getting-massage'),
(379, ':person-getting-haircut:', 'person-getting-haircut'),
(380, ':man-getting-haircut:', 'man-getting-haircut'),
(381, ':woman-getting-haircut:', 'woman-getting-haircut'),
(382, ':person-walking:', 'person-walking'),
(383, ':man-walking:', 'man-walking'),
(384, ':woman-walking:', 'woman-walking'),
(385, ':person-standing:', 'person-standing'),
(386, ':man-standing:', 'man-standing'),
(387, ':woman-standing:', 'woman-standing'),
(388, ':person-kneeling:', 'person-kneeling'),
(389, ':man-kneeling:', 'man-kneeling'),
(390, ':woman-kneeling:', 'woman-kneeling'),
(391, ':person-with-white-cane:', 'person-with-white-cane'),
(392, ':man-with-white-cane:', 'man-with-white-cane'),
(393, ':woman-with-white-cane:', 'woman-with-white-cane'),
(394, ':person-in-motorized-wheelchair:', 'person-in-motorized-wheelchair'),
(395, ':man-in-motorized-wheelchair:', 'man-in-motorized-wheelchair'),
(396, ':woman-in-motorized-wheelchair:', 'woman-in-motorized-wheelchair'),
(397, ':person-in-manual-wheelchair:', 'person-in-manual-wheelchair'),
(398, ':man-in-manual-wheelchair:', 'man-in-manual-wheelchair'),
(399, ':woman-in-manual-wheelchair:', 'woman-in-manual-wheelchair'),
(400, ':person-running:', 'person-running'),
(401, ':man-running:', 'man-running'),
(402, ':woman-running:', 'woman-running'),
(403, ':woman-dancing:', 'woman-dancing'),
(404, ':man-dancing:', 'man-dancing'),
(405, ':person-in-suit-levitating:', 'person-in-suit-levitating'),
(406, ':people-with-bunny-ears:', 'people-with-bunny-ears'),
(407, ':men-with-bunny-ears:', 'men-with-bunny-ears'),
(408, ':women-with-bunny-ears:', 'women-with-bunny-ears'),
(409, ':person-in-steamy-room:', 'person-in-steamy-room'),
(410, ':man-in-steamy-room:', 'man-in-steamy-room'),
(411, ':woman-in-steamy-room:', 'woman-in-steamy-room'),
(412, ':person-climbing:', 'person-climbing'),
(413, ':man-climbing:', 'man-climbing'),
(414, ':woman-climbing:', 'woman-climbing'),
(415, ':person-fencing:', 'person-fencing'),
(416, ':horse-racing:', 'horse-racing'),
(417, ':skier:', 'skier'),
(418, ':snowboarder:', 'snowboarder'),
(419, ':person-golfing:', 'person-golfing'),
(420, ':man-golfing:', 'man-golfing'),
(421, ':woman-golfing:', 'woman-golfing'),
(422, ':person-surfing:', 'person-surfing'),
(423, ':man-surfing:', 'man-surfing'),
(424, ':woman-surfing:', 'woman-surfing'),
(425, ':person-rowing-boat:', 'person-rowing-boat'),
(426, ':man-rowing-boat:', 'man-rowing-boat'),
(427, ':woman-rowing-boat:', 'woman-rowing-boat'),
(428, ':person-swimming:', 'person-swimming'),
(429, ':man-swimming:', 'man-swimming'),
(430, ':woman-swimming:', 'woman-swimming'),
(431, ':person-bouncing-ball:', 'person-bouncing-ball'),
(432, ':man-bouncing-ball:', 'man-bouncing-ball'),
(433, ':woman-bouncing-ball:', 'woman-bouncing-ball'),
(434, ':person-lifting-weights:', 'person-lifting-weights'),
(435, ':man-lifting-weights:', 'man-lifting-weights'),
(436, ':woman-lifting-weights:', 'woman-lifting-weights'),
(437, ':person-biking:', 'person-biking'),
(438, ':man-biking:', 'man-biking'),
(439, ':woman-biking:', 'woman-biking'),
(440, ':person-mountain-biking:', 'person-mountain-biking'),
(441, ':man-mountain-biking:', 'man-mountain-biking'),
(442, ':woman-mountain-biking:', 'woman-mountain-biking'),
(443, ':person-cartwheeling:', 'person-cartwheeling'),
(444, ':man-cartwheeling:', 'man-cartwheeling'),
(445, ':woman-cartwheeling:', 'woman-cartwheeling'),
(446, ':people-wrestling:', 'people-wrestling'),
(447, ':men-wrestling:', 'men-wrestling'),
(448, ':women-wrestling:', 'women-wrestling'),
(449, ':person-playing-water-polo:', 'person-playing-water-polo'),
(450, ':man-playing-water-polo:', 'man-playing-water-polo'),
(451, ':woman-playing-water-polo:', 'woman-playing-water-polo'),
(452, ':person-playing-handball:', 'person-playing-handball'),
(453, ':man-playing-handball:', 'man-playing-handball'),
(454, ':woman-playing-handball:', 'woman-playing-handball'),
(455, ':person-juggling:', 'person-juggling'),
(456, ':man-juggling:', 'man-juggling'),
(457, ':woman-juggling:', 'woman-juggling'),
(458, ':person-in-lotus-position:', 'person-in-lotus-position'),
(459, ':man-in-lotus-position:', 'man-in-lotus-position'),
(460, ':woman-in-lotus-position:', 'woman-in-lotus-position'),
(461, ':person-taking-bath:', 'person-taking-bath'),
(462, ':person-in-bed:', 'person-in-bed'),
(463, ':people-holding-hands:', 'people-holding-hands'),
(464, ':women-holding-hands:', 'women-holding-hands'),
(465, ':woman-and-man-holding-hands:', 'woman-and-man-holding-hands'),
(466, ':men-holding-hands:', 'men-holding-hands'),
(467, ':kiss:', 'kiss'),
(468, ':kiss-woman-man:', 'kiss-woman-man'),
(469, ':kiss-man-man:', 'kiss-man-man'),
(470, ':kiss-woman-woman:', 'kiss-woman-woman'),
(471, ':couple-with-heart:', 'couple-with-heart'),
(472, ':couple-with-heart-woman-man:', 'couple-with-heart-woman-man'),
(473, ':couple-with-heart-man-man:', 'couple-with-heart-man-man'),
(474, ':couple-with-heart-woman-woman:', 'couple-with-heart-woman-woman'),
(475, ':family:', 'family'),
(476, ':family-man-woman-boy:', 'family-man-woman-boy'),
(477, ':family-man-woman-girl:', 'family-man-woman-girl'),
(478, ':family-man-woman-girl-boy:', 'family-man-woman-girl-boy'),
(479, ':family-man-woman-boy-boy:', 'family-man-woman-boy-boy'),
(480, ':family-man-woman-girl-girl:', 'family-man-woman-girl-girl'),
(481, ':family-man-man-boy:', 'family-man-man-boy'),
(482, ':family-man-man-girl:', 'family-man-man-girl'),
(483, ':family-man-man-girl-boy:', 'family-man-man-girl-boy'),
(484, ':family-man-man-boy-boy:', 'family-man-man-boy-boy'),
(485, ':family-man-man-girl-girl:', 'family-man-man-girl-girl'),
(486, ':family-woman-woman-boy:', 'family-woman-woman-boy'),
(487, ':family-woman-woman-girl:', 'family-woman-woman-girl'),
(488, ':family-woman-woman-girl-boy:', 'family-woman-woman-girl-boy'),
(489, ':family-woman-woman-boy-boy:', 'family-woman-woman-boy-boy'),
(490, ':family-woman-woman-girl-girl:', 'family-woman-woman-girl-girl'),
(491, ':family-man-boy:', 'family-man-boy'),
(492, ':family-man-boy-boy:', 'family-man-boy-boy'),
(493, ':family-man-girl:', 'family-man-girl'),
(494, ':family-man-girl-boy:', 'family-man-girl-boy'),
(495, ':family-man-girl-girl:', 'family-man-girl-girl'),
(496, ':family-woman-boy:', 'family-woman-boy'),
(497, ':family-woman-boy-boy:', 'family-woman-boy-boy'),
(498, ':family-woman-girl:', 'family-woman-girl'),
(499, ':family-woman-girl-boy:', 'family-woman-girl-boy'),
(500, ':family-woman-girl-girl:', 'family-woman-girl-girl'),
(501, ':speaking-head:', 'speaking-head'),
(502, ':bust-in-silhouette:', 'bust-in-silhouette'),
(503, ':busts-in-silhouette:', 'busts-in-silhouette'),
(504, ':people-hugging:', 'people-hugging'),
(505, ':footprints:', 'footprints'),
(506, ':red-hair:', 'red-hair'),
(507, ':curly-hair:', 'curly-hair'),
(508, ':white-hair:', 'white-hair'),
(509, ':bald:', 'bald'),
(510, ':monkey-face:', 'monkey-face'),
(511, ':monkey:', 'monkey'),
(512, ':gorilla:', 'gorilla'),
(513, ':orangutan:', 'orangutan'),
(514, ':dog-face:', 'dog-face'),
(515, ':dog:', 'dog'),
(516, ':guide-dog:', 'guide-dog'),
(517, ':service-dog:', 'service-dog'),
(518, ':poodle:', 'poodle'),
(519, ':wolf:', 'wolf'),
(520, ':fox:', 'fox'),
(521, ':raccoon:', 'raccoon'),
(522, ':cat-face:', 'cat-face'),
(523, ':cat:', 'cat'),
(524, ':black-cat:', 'black-cat'),
(525, ':lion:', 'lion'),
(526, ':tiger-face:', 'tiger-face'),
(527, ':tiger:', 'tiger'),
(528, ':leopard:', 'leopard'),
(529, ':horse-face:', 'horse-face'),
(530, ':horse:', 'horse'),
(531, ':unicorn:', 'unicorn'),
(532, ':zebra:', 'zebra'),
(533, ':deer:', 'deer'),
(534, ':bison:', 'bison'),
(535, ':cow-face:', 'cow-face'),
(536, ':ox:', 'ox'),
(537, ':water-buffalo:', 'water-buffalo'),
(538, ':cow:', 'cow'),
(539, ':pig-face:', 'pig-face'),
(540, ':pig:', 'pig'),
(541, ':boar:', 'boar'),
(542, ':pig-nose:', 'pig-nose'),
(543, ':ram:', 'ram'),
(544, ':ewe:', 'ewe'),
(545, ':goat:', 'goat'),
(546, ':camel:', 'camel'),
(547, ':two-hump-camel:', 'two-hump-camel'),
(548, ':llama:', 'llama'),
(549, ':giraffe:', 'giraffe'),
(550, ':elephant:', 'elephant'),
(551, ':mammoth:', 'mammoth'),
(552, ':rhinoceros:', 'rhinoceros'),
(553, ':hippopotamus:', 'hippopotamus'),
(554, ':mouse-face:', 'mouse-face'),
(555, ':mouse:', 'mouse'),
(556, ':rat:', 'rat'),
(557, ':hamster:', 'hamster'),
(558, ':rabbit-face:', 'rabbit-face'),
(559, ':rabbit:', 'rabbit'),
(560, ':chipmunk:', 'chipmunk'),
(561, ':beaver:', 'beaver'),
(562, ':hedgehog:', 'hedgehog'),
(563, ':bat:', 'bat'),
(564, ':bear:', 'bear'),
(565, ':polar-bear:', 'polar-bear'),
(566, ':koala:', 'koala'),
(567, ':panda:', 'panda'),
(568, ':sloth:', 'sloth'),
(569, ':otter:', 'otter'),
(570, ':skunk:', 'skunk'),
(571, ':kangaroo:', 'kangaroo'),
(572, ':badger:', 'badger'),
(573, ':paw-prints:', 'paw-prints'),
(574, ':turkey:', 'turkey'),
(575, ':chicken:', 'chicken'),
(576, ':rooster:', 'rooster'),
(577, ':hatching-chick:', 'hatching-chick'),
(578, ':baby-chick:', 'baby-chick'),
(579, ':front-facing-baby-chick:', 'front-facing-baby-chick'),
(580, ':bird:', 'bird'),
(581, ':penguin:', 'penguin'),
(582, ':dove:', 'dove'),
(583, ':eagle:', 'eagle'),
(584, ':duck:', 'duck'),
(585, ':swan:', 'swan'),
(586, ':owl:', 'owl'),
(587, ':dodo:', 'dodo'),
(588, ':feather:', 'feather'),
(589, ':flamingo:', 'flamingo'),
(590, ':peacock:', 'peacock'),
(591, ':parrot:', 'parrot'),
(592, ':frog:', 'frog'),
(593, ':crocodile:', 'crocodile'),
(594, ':turtle:', 'turtle'),
(595, ':lizard:', 'lizard'),
(596, ':snake:', 'snake'),
(597, ':dragon-face:', 'dragon-face'),
(598, ':dragon:', 'dragon'),
(599, ':sauropod:', 'sauropod'),
(600, ':t-rex:', 't-rex'),
(601, ':spouting-whale:', 'spouting-whale'),
(602, ':whale:', 'whale'),
(603, ':dolphin:', 'dolphin'),
(604, ':seal:', 'seal'),
(605, ':fish:', 'fish'),
(606, ':tropical-fish:', 'tropical-fish'),
(607, ':blowfish:', 'blowfish'),
(608, ':shark:', 'shark'),
(609, ':octopus:', 'octopus'),
(610, ':spiral-shell:', 'spiral-shell'),
(611, ':snail:', 'snail'),
(612, ':butterfly:', 'butterfly'),
(613, ':bug:', 'bug'),
(614, ':ant:', 'ant'),
(615, ':honeybee:', 'honeybee'),
(616, ':beetle:', 'beetle'),
(617, ':lady-beetle:', 'lady-beetle'),
(618, ':cricket:', 'cricket'),
(619, ':cockroach:', 'cockroach'),
(620, ':spider:', 'spider'),
(621, ':spider-web:', 'spider-web'),
(622, ':scorpion:', 'scorpion'),
(623, ':mosquito:', 'mosquito'),
(624, ':fly:', 'fly'),
(625, ':worm:', 'worm'),
(626, ':microbe:', 'microbe'),
(627, ':bouquet:', 'bouquet'),
(628, ':cherry-blossom:', 'cherry-blossom'),
(629, ':white-flower:', 'white-flower'),
(630, ':rosette:', 'rosette'),
(631, ':rose:', 'rose'),
(632, ':wilted-flower:', 'wilted-flower'),
(633, ':hibiscus:', 'hibiscus'),
(634, ':sunflower:', 'sunflower'),
(635, ':blossom:', 'blossom'),
(636, ':tulip:', 'tulip'),
(637, ':seedling:', 'seedling'),
(638, ':potted-plant:', 'potted-plant'),
(639, ':evergreen-tree:', 'evergreen-tree'),
(640, ':deciduous-tree:', 'deciduous-tree'),
(641, ':palm-tree:', 'palm-tree'),
(642, ':cactus:', 'cactus'),
(643, ':sheaf-of-rice:', 'sheaf-of-rice'),
(644, ':herb:', 'herb'),
(645, ':shamrock:', 'shamrock'),
(646, ':four-leaf-clover:', 'four-leaf-clover'),
(647, ':maple-leaf:', 'maple-leaf'),
(648, ':fallen-leaf:', 'fallen-leaf'),
(649, ':leaf-fluttering-in-wind:', 'leaf-fluttering-in-wind'),
(650, ':grapes:', 'grapes'),
(651, ':melon:', 'melon'),
(652, ':watermelon:', 'watermelon'),
(653, ':tangerine:', 'tangerine'),
(654, ':lemon:', 'lemon'),
(655, ':banana:', 'banana'),
(656, ':pineapple:', 'pineapple'),
(657, ':mango:', 'mango'),
(658, ':red-apple:', 'red-apple'),
(659, ':green-apple:', 'green-apple'),
(660, ':pear:', 'pear'),
(661, ':peach:', 'peach'),
(662, ':cherries:', 'cherries'),
(663, ':strawberry:', 'strawberry'),
(664, ':blueberries:', 'blueberries'),
(665, ':kiwi-fruit:', 'kiwi-fruit'),
(666, ':tomato:', 'tomato'),
(667, ':olive:', 'olive'),
(668, ':coconut:', 'coconut'),
(669, ':avocado:', 'avocado'),
(670, ':eggplant:', 'eggplant'),
(671, ':potato:', 'potato'),
(672, ':carrot:', 'carrot'),
(673, ':ear-of-corn:', 'ear-of-corn'),
(674, ':hot-pepper:', 'hot-pepper'),
(675, ':bell-pepper:', 'bell-pepper'),
(676, ':cucumber:', 'cucumber'),
(677, ':leafy-green:', 'leafy-green'),
(678, ':broccoli:', 'broccoli'),
(679, ':garlic:', 'garlic'),
(680, ':onion:', 'onion'),
(681, ':mushroom:', 'mushroom'),
(682, ':peanuts:', 'peanuts'),
(683, ':chestnut:', 'chestnut'),
(684, ':bread:', 'bread'),
(685, ':croissant:', 'croissant'),
(686, ':baguette-bread:', 'baguette-bread'),
(687, ':flatbread:', 'flatbread'),
(688, ':pretzel:', 'pretzel'),
(689, ':bagel:', 'bagel'),
(690, ':pancakes:', 'pancakes'),
(691, ':waffle:', 'waffle'),
(692, ':cheese-wedge:', 'cheese-wedge'),
(693, ':meat-on-bone:', 'meat-on-bone'),
(694, ':poultry-leg:', 'poultry-leg'),
(695, ':cut-of-meat:', 'cut-of-meat'),
(696, ':bacon:', 'bacon'),
(697, ':hamburger:', 'hamburger'),
(698, ':french-fries:', 'french-fries'),
(699, ':pizza:', 'pizza'),
(700, ':hot-dog:', 'hot-dog'),
(701, ':sandwich:', 'sandwich'),
(702, ':taco:', 'taco'),
(703, ':burrito:', 'burrito'),
(704, ':tamale:', 'tamale'),
(705, ':stuffed-flatbread:', 'stuffed-flatbread'),
(706, ':falafel:', 'falafel'),
(707, ':egg:', 'egg'),
(708, ':cooking:', 'cooking'),
(709, ':shallow-pan-of-food:', 'shallow-pan-of-food'),
(710, ':pot-of-food:', 'pot-of-food'),
(711, ':fondue:', 'fondue'),
(712, ':bowl-with-spoon:', 'bowl-with-spoon'),
(713, ':green-salad:', 'green-salad'),
(714, ':popcorn:', 'popcorn'),
(715, ':butter:', 'butter'),
(716, ':salt:', 'salt'),
(717, ':canned-food:', 'canned-food'),
(718, ':bento-box:', 'bento-box'),
(719, ':rice-cracker:', 'rice-cracker'),
(720, ':rice-ball:', 'rice-ball'),
(721, ':cooked-rice:', 'cooked-rice'),
(722, ':curry-rice:', 'curry-rice'),
(723, ':steaming-bowl:', 'steaming-bowl'),
(724, ':spaghetti:', 'spaghetti'),
(725, ':roasted-sweet-potato:', 'roasted-sweet-potato'),
(726, ':oden:', 'oden'),
(727, ':sushi:', 'sushi'),
(728, ':fried-shrimp:', 'fried-shrimp'),
(729, ':fish-cake-with-swirl:', 'fish-cake-with-swirl'),
(730, ':moon-cake:', 'moon-cake'),
(731, ':dango:', 'dango'),
(732, ':dumpling:', 'dumpling'),
(733, ':fortune-cookie:', 'fortune-cookie'),
(734, ':takeout-box:', 'takeout-box'),
(735, ':crab:', 'crab'),
(736, ':lobster:', 'lobster'),
(737, ':shrimp:', 'shrimp'),
(738, ':squid:', 'squid'),
(739, ':oyster:', 'oyster'),
(740, ':soft-ice-cream:', 'soft-ice-cream'),
(741, ':shaved-ice:', 'shaved-ice'),
(742, ':ice-cream:', 'ice-cream'),
(743, ':doughnut:', 'doughnut'),
(744, ':cookie:', 'cookie'),
(745, ':birthday-cake:', 'birthday-cake'),
(746, ':shortcake:', 'shortcake'),
(747, ':cupcake:', 'cupcake'),
(748, ':pie:', 'pie'),
(749, ':chocolate-bar:', 'chocolate-bar'),
(750, ':candy:', 'candy'),
(751, ':lollipop:', 'lollipop'),
(752, ':custard:', 'custard'),
(753, ':honey-pot:', 'honey-pot'),
(754, ':baby-bottle:', 'baby-bottle'),
(755, ':glass-of-milk:', 'glass-of-milk'),
(756, ':hot-beverage:', 'hot-beverage'),
(757, ':teapot:', 'teapot'),
(758, ':teacup-without-handle:', 'teacup-without-handle'),
(759, ':sake:', 'sake'),
(760, ':bottle-with-popping-cork:', 'bottle-with-popping-cork'),
(761, ':wine-glass:', 'wine-glass'),
(762, ':cocktail-glass:', 'cocktail-glass'),
(763, ':tropical-drink:', 'tropical-drink'),
(764, ':beer-mug:', 'beer-mug'),
(765, ':clinking-beer-mugs:', 'clinking-beer-mugs'),
(766, ':clinking-glasses:', 'clinking-glasses'),
(767, ':tumbler-glass:', 'tumbler-glass'),
(768, ':cup-with-straw:', 'cup-with-straw'),
(769, ':bubble-tea:', 'bubble-tea'),
(770, ':beverage-box:', 'beverage-box'),
(771, ':mate:', 'mate'),
(772, ':ice:', 'ice'),
(773, ':chopsticks:', 'chopsticks'),
(774, ':fork-and-knife-with-plate:', 'fork-and-knife-with-plate'),
(775, ':fork-and-knife:', 'fork-and-knife'),
(776, ':spoon:', 'spoon'),
(777, ':kitchen-knife:', 'kitchen-knife'),
(778, ':amphora:', 'amphora'),
(779, ':globe-showing-europe-africa:', 'globe-showing-europe-africa'),
(780, ':globe-showing-americas:', 'globe-showing-americas'),
(781, ':globe-showing-asia-australia:', 'globe-showing-asia-australia'),
(782, ':globe-with-meridians:', 'globe-with-meridians'),
(783, ':world-map:', 'world-map'),
(784, ':map-of-japan:', 'map-of-japan'),
(785, ':compass:', 'compass'),
(786, ':snow-capped-mountain:', 'snow-capped-mountain'),
(787, ':mountain:', 'mountain'),
(788, ':volcano:', 'volcano'),
(789, ':mount-fuji:', 'mount-fuji'),
(790, ':camping:', 'camping'),
(791, ':beach-with-umbrella:', 'beach-with-umbrella'),
(792, ':desert:', 'desert'),
(793, ':desert-island:', 'desert-island'),
(794, ':national-park:', 'national-park'),
(795, ':stadium:', 'stadium'),
(796, ':classical-building:', 'classical-building'),
(797, ':building-construction:', 'building-construction'),
(798, ':brick:', 'brick'),
(799, ':rock:', 'rock'),
(800, ':wood:', 'wood'),
(801, ':hut:', 'hut'),
(802, ':houses:', 'houses'),
(803, ':derelict-house:', 'derelict-house'),
(804, ':house:', 'house'),
(805, ':house-with-garden:', 'house-with-garden'),
(806, ':office-building:', 'office-building'),
(807, ':japanese-post-office:', 'japanese-post-office'),
(808, ':post-office:', 'post-office'),
(809, ':hospital:', 'hospital'),
(810, ':bank:', 'bank'),
(811, ':hotel:', 'hotel'),
(812, ':love-hotel:', 'love-hotel'),
(813, ':convenience-store:', 'convenience-store'),
(814, ':school:', 'school'),
(815, ':department-store:', 'department-store'),
(816, ':factory:', 'factory'),
(817, ':japanese-castle:', 'japanese-castle'),
(818, ':castle:', 'castle'),
(819, ':wedding:', 'wedding'),
(820, ':tokyo-tower:', 'tokyo-tower'),
(821, ':statue-of-liberty:', 'statue-of-liberty'),
(822, ':church:', 'church'),
(823, ':mosque:', 'mosque'),
(824, ':hindu-temple:', 'hindu-temple'),
(825, ':synagogue:', 'synagogue'),
(826, ':shinto-shrine:', 'shinto-shrine'),
(827, ':kaaba:', 'kaaba'),
(828, ':fountain:', 'fountain'),
(829, ':tent:', 'tent'),
(830, ':foggy:', 'foggy'),
(831, ':night-with-stars:', 'night-with-stars'),
(832, ':cityscape:', 'cityscape'),
(833, ':sunrise-over-mountains:', 'sunrise-over-mountains'),
(834, ':sunrise:', 'sunrise'),
(835, ':cityscape-at-dusk:', 'cityscape-at-dusk'),
(836, ':sunset:', 'sunset'),
(837, ':bridge-at-night:', 'bridge-at-night'),
(838, ':hot-springs:', 'hot-springs'),
(839, ':carousel-horse:', 'carousel-horse'),
(840, ':ferris-wheel:', 'ferris-wheel'),
(841, ':roller-coaster:', 'roller-coaster'),
(842, ':barber-pole:', 'barber-pole'),
(843, ':circus-tent:', 'circus-tent'),
(844, ':locomotive:', 'locomotive'),
(845, ':railway-car:', 'railway-car'),
(846, ':high-speed-train:', 'high-speed-train'),
(847, ':bullet-train:', 'bullet-train'),
(848, ':train:', 'train'),
(849, ':metro:', 'metro'),
(850, ':light-rail:', 'light-rail'),
(851, ':station:', 'station'),
(852, ':tram:', 'tram'),
(853, ':monorail:', 'monorail'),
(854, ':mountain-railway:', 'mountain-railway'),
(855, ':tram-car:', 'tram-car'),
(856, ':bus:', 'bus'),
(857, ':oncoming-bus:', 'oncoming-bus'),
(858, ':trolleybus:', 'trolleybus'),
(859, ':minibus:', 'minibus'),
(860, ':ambulance:', 'ambulance'),
(861, ':fire-engine:', 'fire-engine'),
(862, ':police-car:', 'police-car'),
(863, ':oncoming-police-car:', 'oncoming-police-car'),
(864, ':taxi:', 'taxi'),
(865, ':oncoming-taxi:', 'oncoming-taxi'),
(866, ':automobile:', 'automobile'),
(867, ':oncoming-automobile:', 'oncoming-automobile'),
(868, ':sport-utility-vehicle:', 'sport-utility-vehicle'),
(869, ':pickup-truck:', 'pickup-truck'),
(870, ':delivery-truck:', 'delivery-truck'),
(871, ':articulated-lorry:', 'articulated-lorry'),
(872, ':tractor:', 'tractor'),
(873, ':racing-car:', 'racing-car'),
(874, ':motorcycle:', 'motorcycle'),
(875, ':motor-scooter:', 'motor-scooter'),
(876, ':manual-wheelchair:', 'manual-wheelchair'),
(877, ':motorized-wheelchair:', 'motorized-wheelchair'),
(878, ':auto-rickshaw:', 'auto-rickshaw'),
(879, ':bicycle:', 'bicycle'),
(880, ':kick-scooter:', 'kick-scooter'),
(881, ':skateboard:', 'skateboard'),
(882, ':roller-skate:', 'roller-skate'),
(883, ':bus-stop:', 'bus-stop'),
(884, ':motorway:', 'motorway'),
(885, ':railway-track:', 'railway-track'),
(886, ':oil-drum:', 'oil-drum'),
(887, ':fuel-pump:', 'fuel-pump'),
(888, ':police-car-light:', 'police-car-light'),
(889, ':horizontal-traffic-light:', 'horizontal-traffic-light'),
(890, ':vertical-traffic-light:', 'vertical-traffic-light'),
(891, ':stop-sign:', 'stop-sign'),
(892, ':construction:', 'construction'),
(893, ':anchor:', 'anchor'),
(894, ':sailboat:', 'sailboat'),
(895, ':canoe:', 'canoe'),
(896, ':speedboat:', 'speedboat'),
(897, ':passenger-ship:', 'passenger-ship'),
(898, ':ferry:', 'ferry'),
(899, ':motor-boat:', 'motor-boat'),
(900, ':ship:', 'ship'),
(901, ':airplane:', 'airplane'),
(902, ':small-airplane:', 'small-airplane'),
(903, ':airplane-departure:', 'airplane-departure'),
(904, ':airplane-arrival:', 'airplane-arrival'),
(905, ':parachute:', 'parachute'),
(906, ':seat:', 'seat'),
(907, ':helicopter:', 'helicopter'),
(908, ':suspension-railway:', 'suspension-railway'),
(909, ':mountain-cableway:', 'mountain-cableway'),
(910, ':aerial-tramway:', 'aerial-tramway'),
(911, ':satellite:', 'satellite'),
(912, ':rocket:', 'rocket'),
(913, ':flying-saucer:', 'flying-saucer'),
(914, ':bellhop-bell:', 'bellhop-bell'),
(915, ':luggage:', 'luggage'),
(916, ':hourglass-done:', 'hourglass-done'),
(917, ':hourglass-not-done:', 'hourglass-not-done'),
(918, ':watch:', 'watch'),
(919, ':alarm-clock:', 'alarm-clock'),
(920, ':stopwatch:', 'stopwatch'),
(921, ':timer-clock:', 'timer-clock'),
(922, ':mantelpiece-clock:', 'mantelpiece-clock'),
(923, ':twelve-o-clock:', 'twelve-o-clock'),
(924, ':twelve-thirty:', 'twelve-thirty'),
(925, ':one-o-clock:', 'one-o-clock'),
(926, ':one-thirty:', 'one-thirty'),
(927, ':two-o-clock:', 'two-o-clock'),
(928, ':two-thirty:', 'two-thirty'),
(929, ':three-o-clock:', 'three-o-clock'),
(930, ':three-thirty:', 'three-thirty'),
(931, ':four-o-clock:', 'four-o-clock'),
(932, ':four-thirty:', 'four-thirty'),
(933, ':five-o-clock:', 'five-o-clock'),
(934, ':five-thirty:', 'five-thirty'),
(935, ':six-o-clock:', 'six-o-clock'),
(936, ':six-thirty:', 'six-thirty'),
(937, ':seven-o-clock:', 'seven-o-clock'),
(938, ':seven-thirty:', 'seven-thirty'),
(939, ':eight-o-clock:', 'eight-o-clock'),
(940, ':eight-thirty:', 'eight-thirty'),
(941, ':nine-o-clock:', 'nine-o-clock'),
(942, ':nine-thirty:', 'nine-thirty'),
(943, ':ten-o-clock:', 'ten-o-clock'),
(944, ':ten-thirty:', 'ten-thirty'),
(945, ':eleven-o-clock:', 'eleven-o-clock'),
(946, ':eleven-thirty:', 'eleven-thirty'),
(947, ':new-moon:', 'new-moon'),
(948, ':waxing-crescent-moon:', 'waxing-crescent-moon'),
(949, ':first-quarter-moon:', 'first-quarter-moon'),
(950, ':waxing-gibbous-moon:', 'waxing-gibbous-moon'),
(951, ':full-moon:', 'full-moon'),
(952, ':waning-gibbous-moon:', 'waning-gibbous-moon'),
(953, ':last-quarter-moon:', 'last-quarter-moon'),
(954, ':waning-crescent-moon:', 'waning-crescent-moon'),
(955, ':crescent-moon:', 'crescent-moon'),
(956, ':new-moon-face:', 'new-moon-face'),
(957, ':first-quarter-moon-face:', 'first-quarter-moon-face'),
(958, ':last-quarter-moon-face:', 'last-quarter-moon-face'),
(959, ':thermometer:', 'thermometer'),
(960, ':sun:', 'sun'),
(961, ':full-moon-face:', 'full-moon-face'),
(962, ':sun-with-face:', 'sun-with-face'),
(963, ':ringed-planet:', 'ringed-planet'),
(964, ':star:', 'star'),
(965, ':glowing-star:', 'glowing-star'),
(966, ':shooting-star:', 'shooting-star'),
(967, ':milky-way:', 'milky-way'),
(968, ':cloud:', 'cloud'),
(969, ':sun-behind-cloud:', 'sun-behind-cloud'),
(970, ':cloud-with-lightning-and-rain:', 'cloud-with-lightning-and-rain'),
(971, ':sun-behind-small-cloud:', 'sun-behind-small-cloud'),
(972, ':sun-behind-large-cloud:', 'sun-behind-large-cloud'),
(973, ':sun-behind-rain-cloud:', 'sun-behind-rain-cloud'),
(974, ':cloud-with-rain:', 'cloud-with-rain'),
(975, ':cloud-with-snow:', 'cloud-with-snow'),
(976, ':cloud-with-lightning:', 'cloud-with-lightning'),
(977, ':tornado:', 'tornado'),
(978, ':fog:', 'fog'),
(979, ':wind-face:', 'wind-face'),
(980, ':cyclone:', 'cyclone'),
(981, ':rainbow:', 'rainbow'),
(982, ':closed-umbrella:', 'closed-umbrella'),
(983, ':umbrella:', 'umbrella'),
(984, ':umbrella-with-rain-drops:', 'umbrella-with-rain-drops'),
(985, ':umbrella-on-ground:', 'umbrella-on-ground'),
(986, ':high-voltage:', 'high-voltage'),
(987, ':snowflake:', 'snowflake'),
(988, ':snowman:', 'snowman'),
(989, ':snowman-without-snow:', 'snowman-without-snow'),
(990, ':comet:', 'comet'),
(991, ':fire:', 'fire'),
(992, ':droplet:', 'droplet'),
(993, ':water-wave:', 'water-wave'),
(994, ':jack-o-lantern:', 'jack-o-lantern'),
(995, ':christmas-tree:', 'christmas-tree'),
(996, ':fireworks:', 'fireworks'),
(997, ':sparkler:', 'sparkler'),
(998, ':firecracker:', 'firecracker'),
(999, ':sparkles:', 'sparkles'),
(1000, ':balloon:', 'balloon'),
(1001, ':party-popper:', 'party-popper'),
(1002, ':confetti-ball:', 'confetti-ball'),
(1003, ':tanabata-tree:', 'tanabata-tree'),
(1004, ':pine-decoration:', 'pine-decoration'),
(1005, ':japanese-dolls:', 'japanese-dolls'),
(1006, ':carp-streamer:', 'carp-streamer'),
(1007, ':wind-chime:', 'wind-chime'),
(1008, ':moon-viewing-ceremony:', 'moon-viewing-ceremony'),
(1009, ':red-envelope:', 'red-envelope'),
(1010, ':ribbon:', 'ribbon'),
(1011, ':wrapped-gift:', 'wrapped-gift'),
(1012, ':reminder-ribbon:', 'reminder-ribbon'),
(1013, ':admission-tickets:', 'admission-tickets'),
(1014, ':ticket:', 'ticket'),
(1015, ':military-medal:', 'military-medal'),
(1016, ':trophy:', 'trophy'),
(1017, ':sports-medal:', 'sports-medal'),
(1018, ':1st-place-medal:', '1st-place-medal'),
(1019, ':2nd-place-medal:', '2nd-place-medal'),
(1020, ':3rd-place-medal:', '3rd-place-medal'),
(1021, ':soccer-ball:', 'soccer-ball'),
(1022, ':baseball:', 'baseball'),
(1023, ':softball:', 'softball'),
(1024, ':basketball:', 'basketball'),
(1025, ':volleyball:', 'volleyball'),
(1026, ':american-football:', 'american-football'),
(1027, ':rugby-football:', 'rugby-football'),
(1028, ':tennis:', 'tennis'),
(1029, ':flying-disc:', 'flying-disc'),
(1030, ':bowling:', 'bowling'),
(1031, ':cricket-game:', 'cricket-game'),
(1032, ':field-hockey:', 'field-hockey'),
(1033, ':ice-hockey:', 'ice-hockey'),
(1034, ':lacrosse:', 'lacrosse'),
(1035, ':ping-pong:', 'ping-pong'),
(1036, ':badminton:', 'badminton'),
(1037, ':boxing-glove:', 'boxing-glove'),
(1038, ':martial-arts-uniform:', 'martial-arts-uniform'),
(1039, ':goal-net:', 'goal-net'),
(1040, ':flag-in-hole:', 'flag-in-hole'),
(1041, ':ice-skate:', 'ice-skate'),
(1042, ':fishing-pole:', 'fishing-pole'),
(1043, ':diving-mask:', 'diving-mask'),
(1044, ':running-shirt:', 'running-shirt'),
(1045, ':skis:', 'skis'),
(1046, ':sled:', 'sled'),
(1047, ':curling-stone:', 'curling-stone'),
(1048, ':bullseye:', 'bullseye'),
(1049, ':yo-yo:', 'yo-yo'),
(1050, ':kite:', 'kite'),
(1051, ':pool-8-ball:', 'pool-8-ball'),
(1052, ':crystal-ball:', 'crystal-ball'),
(1053, ':magic-wand:', 'magic-wand'),
(1054, ':nazar-amulet:', 'nazar-amulet'),
(1055, ':video-game:', 'video-game'),
(1056, ':joystick:', 'joystick'),
(1057, ':slot-machine:', 'slot-machine'),
(1058, ':game-die:', 'game-die'),
(1059, ':puzzle-piece:', 'puzzle-piece'),
(1060, ':teddy-bear:', 'teddy-bear'),
(1061, ':pi&amp;ntilde;ata:', 'pi&amp;ntilde;ata'),
(1062, ':nesting-dolls:', 'nesting-dolls'),
(1063, ':spade-suit:', 'spade-suit'),
(1064, ':heart-suit:', 'heart-suit'),
(1065, ':diamond-suit:', 'diamond-suit'),
(1066, ':club-suit:', 'club-suit'),
(1067, ':chess-pawn:', 'chess-pawn'),
(1068, ':joker:', 'joker'),
(1069, ':mahjong-red-dragon:', 'mahjong-red-dragon'),
(1070, ':flower-playing-cards:', 'flower-playing-cards'),
(1071, ':performing-arts:', 'performing-arts'),
(1072, ':framed-picture:', 'framed-picture'),
(1073, ':artist-palette:', 'artist-palette'),
(1074, ':thread:', 'thread'),
(1075, ':sewing-needle:', 'sewing-needle'),
(1076, ':yarn:', 'yarn'),
(1077, ':knot:', 'knot'),
(1078, ':glasses:', 'glasses'),
(1079, ':sunglasses:', 'sunglasses'),
(1080, ':goggles:', 'goggles'),
(1081, ':lab-coat:', 'lab-coat'),
(1082, ':safety-vest:', 'safety-vest'),
(1083, ':necktie:', 'necktie'),
(1084, ':t-shirt:', 't-shirt'),
(1085, ':jeans:', 'jeans'),
(1086, ':scarf:', 'scarf'),
(1087, ':gloves:', 'gloves'),
(1088, ':coat:', 'coat'),
(1089, ':socks:', 'socks'),
(1090, ':dress:', 'dress'),
(1091, ':kimono:', 'kimono'),
(1092, ':sari:', 'sari'),
(1093, ':one-piece-swimsuit:', 'one-piece-swimsuit'),
(1094, ':briefs:', 'briefs'),
(1095, ':shorts:', 'shorts'),
(1096, ':bikini:', 'bikini'),
(1097, ':woman-s-clothes:', 'woman-s-clothes'),
(1098, ':purse:', 'purse'),
(1099, ':handbag:', 'handbag'),
(1100, ':clutch-bag:', 'clutch-bag'),
(1101, ':shopping-bags:', 'shopping-bags'),
(1102, ':backpack:', 'backpack'),
(1103, ':thong-sandal:', 'thong-sandal'),
(1104, ':man-s-shoe:', 'man-s-shoe'),
(1105, ':running-shoe:', 'running-shoe'),
(1106, ':hiking-boot:', 'hiking-boot'),
(1107, ':flat-shoe:', 'flat-shoe'),
(1108, ':high-heeled-shoe:', 'high-heeled-shoe'),
(1109, ':woman-s-sandal:', 'woman-s-sandal'),
(1110, ':ballet-shoes:', 'ballet-shoes'),
(1111, ':woman-s-boot:', 'woman-s-boot'),
(1112, ':crown:', 'crown'),
(1113, ':woman-s-hat:', 'woman-s-hat'),
(1114, ':top-hat:', 'top-hat'),
(1115, ':graduation-cap:', 'graduation-cap'),
(1116, ':billed-cap:', 'billed-cap'),
(1117, ':military-helmet:', 'military-helmet'),
(1118, ':rescue-worker-s-helmet:', 'rescue-worker-s-helmet'),
(1119, ':prayer-beads:', 'prayer-beads'),
(1120, ':lipstick:', 'lipstick'),
(1121, ':ring:', 'ring'),
(1122, ':gem-stone:', 'gem-stone'),
(1123, ':muted-speaker:', 'muted-speaker'),
(1124, ':speaker-low-volume:', 'speaker-low-volume'),
(1125, ':speaker-medium-volume:', 'speaker-medium-volume'),
(1126, ':speaker-high-volume:', 'speaker-high-volume'),
(1127, ':loudspeaker:', 'loudspeaker'),
(1128, ':megaphone:', 'megaphone'),
(1129, ':postal-horn:', 'postal-horn'),
(1130, ':bell:', 'bell'),
(1131, ':bell-with-slash:', 'bell-with-slash'),
(1132, ':musical-score:', 'musical-score'),
(1133, ':musical-note:', 'musical-note'),
(1134, ':musical-notes:', 'musical-notes'),
(1135, ':studio-microphone:', 'studio-microphone'),
(1136, ':level-slider:', 'level-slider'),
(1137, ':control-knobs:', 'control-knobs'),
(1138, ':microphone:', 'microphone'),
(1139, ':headphone:', 'headphone'),
(1140, ':radio:', 'radio'),
(1141, ':saxophone:', 'saxophone'),
(1142, ':accordion:', 'accordion'),
(1143, ':guitar:', 'guitar'),
(1144, ':musical-keyboard:', 'musical-keyboard'),
(1145, ':trumpet:', 'trumpet'),
(1146, ':violin:', 'violin'),
(1147, ':banjo:', 'banjo'),
(1148, ':drum:', 'drum'),
(1149, ':long-drum:', 'long-drum'),
(1150, ':mobile-phone:', 'mobile-phone'),
(1151, ':mobile-phone-with-arrow:', 'mobile-phone-with-arrow'),
(1152, ':telephone:', 'telephone'),
(1153, ':telephone-receiver:', 'telephone-receiver'),
(1154, ':pager:', 'pager'),
(1155, ':fax-machine:', 'fax-machine'),
(1156, ':battery:', 'battery'),
(1157, ':electric-plug:', 'electric-plug'),
(1158, ':laptop:', 'laptop'),
(1159, ':desktop-computer:', 'desktop-computer'),
(1160, ':printer:', 'printer'),
(1161, ':keyboard:', 'keyboard'),
(1162, ':computer-mouse:', 'computer-mouse'),
(1163, ':trackball:', 'trackball'),
(1164, ':computer-disk:', 'computer-disk'),
(1165, ':floppy-disk:', 'floppy-disk'),
(1166, ':optical-disk:', 'optical-disk'),
(1167, ':dvd:', 'dvd'),
(1168, ':abacus:', 'abacus'),
(1169, ':movie-camera:', 'movie-camera'),
(1170, ':film-frames:', 'film-frames'),
(1171, ':film-projector:', 'film-projector'),
(1172, ':clapper-board:', 'clapper-board'),
(1173, ':television:', 'television'),
(1174, ':camera:', 'camera'),
(1175, ':camera-with-flash:', 'camera-with-flash'),
(1176, ':video-camera:', 'video-camera'),
(1177, ':videocassette:', 'videocassette'),
(1178, ':magnifying-glass-tilted-left:', 'magnifying-glass-tilted-left'),
(1179, ':magnifying-glass-tilted-right:', 'magnifying-glass-tilted-right'),
(1180, ':candle:', 'candle'),
(1181, ':light-bulb:', 'light-bulb'),
(1182, ':flashlight:', 'flashlight'),
(1183, ':red-paper-lantern:', 'red-paper-lantern'),
(1184, ':diya-lamp:', 'diya-lamp'),
(1185, ':notebook-with-decorative-cover:', 'notebook-with-decorative-cover'),
(1186, ':closed-book:', 'closed-book'),
(1187, ':open-book:', 'open-book'),
(1188, ':green-book:', 'green-book'),
(1189, ':blue-book:', 'blue-book'),
(1190, ':orange-book:', 'orange-book'),
(1191, ':books:', 'books'),
(1192, ':notebook:', 'notebook'),
(1193, ':ledger:', 'ledger'),
(1194, ':page-with-curl:', 'page-with-curl'),
(1195, ':scroll:', 'scroll'),
(1196, ':page-facing-up:', 'page-facing-up'),
(1197, ':newspaper:', 'newspaper'),
(1198, ':rolled-up-newspaper:', 'rolled-up-newspaper'),
(1199, ':bookmark-tabs:', 'bookmark-tabs'),
(1200, ':bookmark:', 'bookmark'),
(1201, ':label:', 'label'),
(1202, ':money-bag:', 'money-bag'),
(1203, ':coin:', 'coin'),
(1204, ':yen-banknote:', 'yen-banknote'),
(1205, ':dollar-banknote:', 'dollar-banknote'),
(1206, ':euro-banknote:', 'euro-banknote'),
(1207, ':pound-banknote:', 'pound-banknote'),
(1208, ':money-with-wings:', 'money-with-wings'),
(1209, ':credit-card:', 'credit-card'),
(1210, ':receipt:', 'receipt'),
(1211, ':chart-increasing-with-yen:', 'chart-increasing-with-yen'),
(1212, ':envelope:', 'envelope'),
(1213, ':e-mail:', 'e-mail'),
(1214, ':incoming-envelope:', 'incoming-envelope'),
(1215, ':envelope-with-arrow:', 'envelope-with-arrow'),
(1216, ':outbox-tray:', 'outbox-tray'),
(1217, ':inbox-tray:', 'inbox-tray'),
(1218, ':package:', 'package'),
(1219, ':closed-mailbox-with-raised-flag:', 'closed-mailbox-with-raised-flag'),
(1220, ':closed-mailbox-with-lowered-flag:', 'closed-mailbox-with-lowered-flag'),
(1221, ':open-mailbox-with-raised-flag:', 'open-mailbox-with-raised-flag'),
(1222, ':open-mailbox-with-lowered-flag:', 'open-mailbox-with-lowered-flag'),
(1223, ':postbox:', 'postbox'),
(1224, ':ballot-box-with-ballot:', 'ballot-box-with-ballot'),
(1225, ':pencil:', 'pencil'),
(1226, ':black-nib:', 'black-nib'),
(1227, ':fountain-pen:', 'fountain-pen'),
(1228, ':pen:', 'pen'),
(1229, ':paintbrush:', 'paintbrush'),
(1230, ':crayon:', 'crayon'),
(1231, ':memo:', 'memo'),
(1232, ':briefcase:', 'briefcase'),
(1233, ':file-folder:', 'file-folder'),
(1234, ':open-file-folder:', 'open-file-folder'),
(1235, ':card-index-dividers:', 'card-index-dividers'),
(1236, ':calendar:', 'calendar'),
(1237, ':tear-off-calendar:', 'tear-off-calendar'),
(1238, ':spiral-notepad:', 'spiral-notepad'),
(1239, ':spiral-calendar:', 'spiral-calendar'),
(1240, ':card-index:', 'card-index'),
(1241, ':chart-increasing:', 'chart-increasing'),
(1242, ':chart-decreasing:', 'chart-decreasing'),
(1243, ':bar-chart:', 'bar-chart'),
(1244, ':clipboard:', 'clipboard'),
(1245, ':pushpin:', 'pushpin'),
(1246, ':round-pushpin:', 'round-pushpin'),
(1247, ':paperclip:', 'paperclip'),
(1248, ':linked-paperclips:', 'linked-paperclips'),
(1249, ':straight-ruler:', 'straight-ruler'),
(1250, ':triangular-ruler:', 'triangular-ruler'),
(1251, ':scissors:', 'scissors'),
(1252, ':card-file-box:', 'card-file-box'),
(1253, ':file-cabinet:', 'file-cabinet'),
(1254, ':wastebasket:', 'wastebasket'),
(1255, ':locked:', 'locked'),
(1256, ':unlocked:', 'unlocked'),
(1257, ':locked-with-pen:', 'locked-with-pen'),
(1258, ':locked-with-key:', 'locked-with-key'),
(1259, ':key:', 'key'),
(1260, ':old-key:', 'old-key'),
(1261, ':hammer:', 'hammer'),
(1262, ':axe:', 'axe'),
(1263, ':pick:', 'pick'),
(1264, ':hammer-and-pick:', 'hammer-and-pick'),
(1265, ':hammer-and-wrench:', 'hammer-and-wrench'),
(1266, ':dagger:', 'dagger'),
(1267, ':crossed-swords:', 'crossed-swords'),
(1268, ':water-pistol:', 'water-pistol'),
(1269, ':boomerang:', 'boomerang'),
(1270, ':bow-and-arrow:', 'bow-and-arrow'),
(1271, ':shield:', 'shield'),
(1272, ':carpentry-saw:', 'carpentry-saw'),
(1273, ':wrench:', 'wrench'),
(1274, ':screwdriver:', 'screwdriver'),
(1275, ':nut-and-bolt:', 'nut-and-bolt'),
(1276, ':gear:', 'gear'),
(1277, ':clamp:', 'clamp'),
(1278, ':balance-scale:', 'balance-scale'),
(1279, ':white-cane:', 'white-cane'),
(1280, ':link:', 'link'),
(1281, ':chains:', 'chains'),
(1282, ':hook:', 'hook'),
(1283, ':toolbox:', 'toolbox'),
(1284, ':magnet:', 'magnet'),
(1285, ':ladder:', 'ladder'),
(1286, ':alembic:', 'alembic'),
(1287, ':test-tube:', 'test-tube'),
(1288, ':petri-dish:', 'petri-dish'),
(1289, ':dna:', 'dna'),
(1290, ':microscope:', 'microscope'),
(1291, ':telescope:', 'telescope'),
(1292, ':satellite-antenna:', 'satellite-antenna'),
(1293, ':syringe:', 'syringe'),
(1294, ':drop-of-blood:', 'drop-of-blood'),
(1295, ':pill:', 'pill'),
(1296, ':adhesive-bandage:', 'adhesive-bandage'),
(1297, ':stethoscope:', 'stethoscope'),
(1298, ':door:', 'door'),
(1299, ':elevator:', 'elevator'),
(1300, ':mirror:', 'mirror'),
(1301, ':window:', 'window'),
(1302, ':bed:', 'bed'),
(1303, ':couch-and-lamp:', 'couch-and-lamp'),
(1304, ':chair:', 'chair'),
(1305, ':toilet:', 'toilet'),
(1306, ':plunger:', 'plunger'),
(1307, ':shower:', 'shower'),
(1308, ':bathtub:', 'bathtub'),
(1309, ':mouse-trap:', 'mouse-trap'),
(1310, ':razor:', 'razor'),
(1311, ':lotion-bottle:', 'lotion-bottle'),
(1312, ':safety-pin:', 'safety-pin'),
(1313, ':broom:', 'broom'),
(1314, ':basket:', 'basket'),
(1315, ':roll-of-paper:', 'roll-of-paper'),
(1316, ':bucket:', 'bucket'),
(1317, ':soap:', 'soap'),
(1318, ':toothbrush:', 'toothbrush'),
(1319, ':sponge:', 'sponge'),
(1320, ':fire-extinguisher:', 'fire-extinguisher'),
(1321, ':shopping-cart:', 'shopping-cart'),
(1322, ':cigarette:', 'cigarette'),
(1323, ':coffin:', 'coffin'),
(1324, ':headstone:', 'headstone'),
(1325, ':funeral-urn:', 'funeral-urn'),
(1326, ':moai:', 'moai'),
(1327, ':placard:', 'placard'),
(1328, ':atm-sign:', 'atm-sign'),
(1329, ':litter-in-bin-sign:', 'litter-in-bin-sign'),
(1330, ':potable-water:', 'potable-water'),
(1331, ':wheelchair-symbol:', 'wheelchair-symbol'),
(1332, ':men-s-room:', 'men-s-room'),
(1333, ':women-s-room:', 'women-s-room'),
(1334, ':restroom:', 'restroom'),
(1335, ':baby-symbol:', 'baby-symbol'),
(1336, ':water-closet:', 'water-closet'),
(1337, ':passport-control:', 'passport-control'),
(1338, ':customs:', 'customs'),
(1339, ':baggage-claim:', 'baggage-claim'),
(1340, ':left-luggage:', 'left-luggage'),
(1341, ':warning:', 'warning'),
(1342, ':children-crossing:', 'children-crossing'),
(1343, ':no-entry:', 'no-entry'),
(1344, ':prohibited:', 'prohibited'),
(1345, ':no-bicycles:', 'no-bicycles'),
(1346, ':no-smoking:', 'no-smoking'),
(1347, ':no-littering:', 'no-littering'),
(1348, ':non-potable-water:', 'non-potable-water'),
(1349, ':no-pedestrians:', 'no-pedestrians'),
(1350, ':no-mobile-phones:', 'no-mobile-phones'),
(1351, ':no-one-under-eighteen:', 'no-one-under-eighteen'),
(1352, ':radioactive:', 'radioactive'),
(1353, ':biohazard:', 'biohazard'),
(1354, ':up-arrow:', 'up-arrow'),
(1355, ':up-right-arrow:', 'up-right-arrow'),
(1356, ':right-arrow:', 'right-arrow'),
(1357, ':down-right-arrow:', 'down-right-arrow'),
(1358, ':down-arrow:', 'down-arrow'),
(1359, ':down-left-arrow:', 'down-left-arrow'),
(1360, ':left-arrow:', 'left-arrow'),
(1361, ':up-left-arrow:', 'up-left-arrow'),
(1362, ':up-down-arrow:', 'up-down-arrow'),
(1363, ':left-right-arrow:', 'left-right-arrow'),
(1364, ':right-arrow-curving-left:', 'right-arrow-curving-left'),
(1365, ':left-arrow-curving-right:', 'left-arrow-curving-right'),
(1366, ':right-arrow-curving-up:', 'right-arrow-curving-up'),
(1367, ':right-arrow-curving-down:', 'right-arrow-curving-down'),
(1368, ':clockwise-vertical-arrows:', 'clockwise-vertical-arrows'),
(1369, ':counterclockwise-arrows-button:', 'counterclockwise-arrows-button'),
(1370, ':back-arrow:', 'back-arrow'),
(1371, ':end-arrow:', 'end-arrow'),
(1372, ':on-arrow:', 'on-arrow'),
(1373, ':soon-arrow:', 'soon-arrow'),
(1374, ':top-arrow:', 'top-arrow'),
(1375, ':place-of-worship:', 'place-of-worship'),
(1376, ':atom-symbol:', 'atom-symbol'),
(1377, ':om:', 'om'),
(1378, ':star-of-david:', 'star-of-david'),
(1379, ':wheel-of-dharma:', 'wheel-of-dharma'),
(1380, ':yin-yang:', 'yin-yang'),
(1381, ':latin-cross:', 'latin-cross'),
(1382, ':orthodox-cross:', 'orthodox-cross'),
(1383, ':star-and-crescent:', 'star-and-crescent'),
(1384, ':peace-symbol:', 'peace-symbol'),
(1385, ':menorah:', 'menorah'),
(1386, ':dotted-six-pointed-star:', 'dotted-six-pointed-star'),
(1387, ':aries:', 'aries'),
(1388, ':taurus:', 'taurus'),
(1389, ':gemini:', 'gemini'),
(1390, ':cancer:', 'cancer'),
(1391, ':leo:', 'leo'),
(1392, ':virgo:', 'virgo'),
(1393, ':libra:', 'libra'),
(1394, ':scorpio:', 'scorpio'),
(1395, ':sagittarius:', 'sagittarius'),
(1396, ':capricorn:', 'capricorn'),
(1397, ':aquarius:', 'aquarius'),
(1398, ':pisces:', 'pisces'),
(1399, ':ophiuchus:', 'ophiuchus'),
(1400, ':shuffle-tracks-button:', 'shuffle-tracks-button'),
(1401, ':repeat-button:', 'repeat-button'),
(1402, ':repeat-single-button:', 'repeat-single-button'),
(1403, ':play-button:', 'play-button'),
(1404, ':fast-forward-button:', 'fast-forward-button'),
(1405, ':next-track-button:', 'next-track-button'),
(1406, ':play-or-pause-button:', 'play-or-pause-button'),
(1407, ':reverse-button:', 'reverse-button'),
(1408, ':fast-reverse-button:', 'fast-reverse-button'),
(1409, ':last-track-button:', 'last-track-button'),
(1410, ':upwards-button:', 'upwards-button'),
(1411, ':fast-up-button:', 'fast-up-button'),
(1412, ':downwards-button:', 'downwards-button'),
(1413, ':fast-down-button:', 'fast-down-button'),
(1414, ':pause-button:', 'pause-button'),
(1415, ':stop-button:', 'stop-button'),
(1416, ':record-button:', 'record-button'),
(1417, ':eject-button:', 'eject-button'),
(1418, ':cinema:', 'cinema'),
(1419, ':dim-button:', 'dim-button'),
(1420, ':bright-button:', 'bright-button'),
(1421, ':antenna-bars:', 'antenna-bars'),
(1422, ':vibration-mode:', 'vibration-mode'),
(1423, ':mobile-phone-off:', 'mobile-phone-off'),
(1424, ':female-sign:', 'female-sign'),
(1425, ':male-sign:', 'male-sign'),
(1426, ':transgender-symbol:', 'transgender-symbol'),
(1427, ':multiply:', 'multiply'),
(1428, ':plus:', 'plus'),
(1429, ':minus:', 'minus'),
(1430, ':divide:', 'divide'),
(1431, ':infinity:', 'infinity'),
(1432, ':double-exclamation-mark:', 'double-exclamation-mark'),
(1433, ':exclamation-question-mark:', 'exclamation-question-mark'),
(1434, ':red-question-mark:', 'red-question-mark'),
(1435, ':white-question-mark:', 'white-question-mark'),
(1436, ':white-exclamation-mark:', 'white-exclamation-mark'),
(1437, ':red-exclamation-mark:', 'red-exclamation-mark'),
(1438, ':wavy-dash:', 'wavy-dash'),
(1439, ':currency-exchange:', 'currency-exchange'),
(1440, ':heavy-dollar-sign:', 'heavy-dollar-sign'),
(1441, ':medical-symbol:', 'medical-symbol'),
(1442, ':recycling-symbol:', 'recycling-symbol'),
(1443, ':fleur-de-lis:', 'fleur-de-lis'),
(1444, ':trident-emblem:', 'trident-emblem'),
(1445, ':name-badge:', 'name-badge'),
(1446, ':japanese-symbol-for-beginner:', 'japanese-symbol-for-beginner'),
(1447, ':hollow-red-circle:', 'hollow-red-circle'),
(1448, ':check-mark-button:', 'check-mark-button'),
(1449, ':check-box-with-check:', 'check-box-with-check'),
(1450, ':check-mark:', 'check-mark'),
(1451, ':cross-mark:', 'cross-mark'),
(1452, ':cross-mark-button:', 'cross-mark-button'),
(1453, ':curly-loop:', 'curly-loop'),
(1454, ':double-curly-loop:', 'double-curly-loop'),
(1455, ':part-alternation-mark:', 'part-alternation-mark'),
(1456, ':eight-spoked-asterisk:', 'eight-spoked-asterisk'),
(1457, ':eight-pointed-star:', 'eight-pointed-star'),
(1458, ':sparkle:', 'sparkle'),
(1459, ':copyright:', 'copyright'),
(1460, ':registered:', 'registered'),
(1461, ':trade-mark:', 'trade-mark'),
(1462, ':keycap-0:', 'keycap-0'),
(1463, ':keycap-1:', 'keycap-1'),
(1464, ':keycap-2:', 'keycap-2'),
(1465, ':keycap-3:', 'keycap-3'),
(1466, ':keycap-4:', 'keycap-4'),
(1467, ':keycap-5:', 'keycap-5'),
(1468, ':keycap-6:', 'keycap-6'),
(1469, ':keycap-7:', 'keycap-7'),
(1470, ':keycap-8:', 'keycap-8'),
(1471, ':keycap-9:', 'keycap-9'),
(1472, ':keycap-10:', 'keycap-10'),
(1473, ':input-latin-uppercase:', 'input-latin-uppercase'),
(1474, ':input-latin-lowercase:', 'input-latin-lowercase'),
(1475, ':input-numbers:', 'input-numbers'),
(1476, ':input-symbols:', 'input-symbols'),
(1477, ':input-latin-letters:', 'input-latin-letters'),
(1478, ':a-button-blood-type:', 'a-button-blood-type'),
(1479, ':ab-button-blood-type:', 'ab-button-blood-type'),
(1480, ':b-button-blood-type:', 'b-button-blood-type'),
(1481, ':cl-button:', 'cl-button'),
(1482, ':cool-button:', 'cool-button'),
(1483, ':free-button:', 'free-button'),
(1484, ':information:', 'information'),
(1485, ':id-button:', 'id-button'),
(1486, ':circled-m:', 'circled-m'),
(1487, ':new-button:', 'new-button'),
(1488, ':ng-button:', 'ng-button'),
(1489, ':o-button-blood-type:', 'o-button-blood-type'),
(1490, ':ok-button:', 'ok-button'),
(1491, ':p-button:', 'p-button'),
(1492, ':sos-button:', 'sos-button'),
(1493, ':up-button:', 'up-button'),
(1494, ':vs-button:', 'vs-button'),
(1495, ':japanese-here-button:', 'japanese-here-button'),
(1496, ':japanese-service-charge-button:', 'japanese-service-charge-button'),
(1497, ':japanese-monthly-amount-button:', 'japanese-monthly-amount-button'),
(1498, ':japanese-not-free-of-charge-button:', 'japanese-not-free-of-charge-button'),
(1499, ':japanese-reserved-button:', 'japanese-reserved-button'),
(1500, ':japanese-bargain-button:', 'japanese-bargain-button'),
(1501, ':japanese-discount-button:', 'japanese-discount-button'),
(1502, ':japanese-free-of-charge-button:', 'japanese-free-of-charge-button'),
(1503, ':japanese-prohibited-button:', 'japanese-prohibited-button'),
(1504, ':japanese-acceptable-button:', 'japanese-acceptable-button'),
(1505, ':japanese-application-button:', 'japanese-application-button'),
(1506, ':japanese-passing-grade-button:', 'japanese-passing-grade-button'),
(1507, ':japanese-vacancy-button:', 'japanese-vacancy-button'),
(1508, ':japanese-congratulations-button:', 'japanese-congratulations-button'),
(1509, ':japanese-secret-button:', 'japanese-secret-button'),
(1510, ':japanese-open-for-business-button:', 'japanese-open-for-business-button'),
(1511, ':japanese-no-vacancy-button:', 'japanese-no-vacancy-button'),
(1512, ':red-circle:', 'red-circle'),
(1513, ':orange-circle:', 'orange-circle'),
(1514, ':yellow-circle:', 'yellow-circle'),
(1515, ':green-circle:', 'green-circle'),
(1516, ':blue-circle:', 'blue-circle'),
(1517, ':purple-circle:', 'purple-circle'),
(1518, ':brown-circle:', 'brown-circle'),
(1519, ':black-circle:', 'black-circle'),
(1520, ':white-circle:', 'white-circle'),
(1521, ':red-square:', 'red-square'),
(1522, ':orange-square:', 'orange-square'),
(1523, ':yellow-square:', 'yellow-square'),
(1524, ':green-square:', 'green-square'),
(1525, ':blue-square:', 'blue-square'),
(1526, ':purple-square:', 'purple-square'),
(1527, ':brown-square:', 'brown-square'),
(1528, ':black-large-square:', 'black-large-square'),
(1529, ':white-large-square:', 'white-large-square'),
(1530, ':black-medium-square:', 'black-medium-square'),
(1531, ':white-medium-square:', 'white-medium-square'),
(1532, ':black-medium-small-square:', 'black-medium-small-square'),
(1533, ':white-medium-small-square:', 'white-medium-small-square'),
(1534, ':black-small-square:', 'black-small-square'),
(1535, ':white-small-square:', 'white-small-square'),
(1536, ':large-orange-diamond:', 'large-orange-diamond'),
(1537, ':large-blue-diamond:', 'large-blue-diamond'),
(1538, ':small-orange-diamond:', 'small-orange-diamond'),
(1539, ':small-blue-diamond:', 'small-blue-diamond'),
(1540, ':red-triangle-pointed-up:', 'red-triangle-pointed-up'),
(1541, ':red-triangle-pointed-down:', 'red-triangle-pointed-down'),
(1542, ':diamond-with-a-dot:', 'diamond-with-a-dot'),
(1543, ':radio-button:', 'radio-button'),
(1544, ':white-square-button:', 'white-square-button'),
(1545, ':black-square-button:', 'black-square-button'),
(1546, ':chequered-flag:', 'chequered-flag'),
(1547, ':triangular-flag:', 'triangular-flag'),
(1548, ':crossed-flags:', 'crossed-flags'),
(1549, ':black-flag:', 'black-flag'),
(1550, ':white-flag:', 'white-flag'),
(1551, ':rainbow-flag:', 'rainbow-flag'),
(1552, ':transgender-flag:', 'transgender-flag'),
(1553, ':pirate-flag:', 'pirate-flag'),
(1554, ':flag-ascension-island:', 'flag-ascension-island'),
(1555, ':flag-andorra:', 'flag-andorra'),
(1556, ':flag-united-arab-emirates:', 'flag-united-arab-emirates'),
(1557, ':flag-afghanistan:', 'flag-afghanistan'),
(1558, ':flag-antigua-barbuda:', 'flag-antigua-barbuda'),
(1559, ':flag-anguilla:', 'flag-anguilla'),
(1560, ':flag-albania:', 'flag-albania'),
(1561, ':flag-armenia:', 'flag-armenia'),
(1562, ':flag-angola:', 'flag-angola'),
(1563, ':flag-antarctica:', 'flag-antarctica'),
(1564, ':flag-argentina:', 'flag-argentina'),
(1565, ':flag-american-samoa:', 'flag-american-samoa'),
(1566, ':flag-austria:', 'flag-austria'),
(1567, ':flag-australia:', 'flag-australia'),
(1568, ':flag-aruba:', 'flag-aruba'),
(1569, ':flag-azerbaijan:', 'flag-azerbaijan'),
(1570, ':flag-bosnia-herzegovina:', 'flag-bosnia-herzegovina'),
(1571, ':flag-barbados:', 'flag-barbados'),
(1572, ':flag-bangladesh:', 'flag-bangladesh'),
(1573, ':flag-belgium:', 'flag-belgium'),
(1574, ':flag-burkina-faso:', 'flag-burkina-faso'),
(1575, ':flag-bulgaria:', 'flag-bulgaria'),
(1576, ':flag-bahrain:', 'flag-bahrain'),
(1577, ':flag-burundi:', 'flag-burundi'),
(1578, ':flag-benin:', 'flag-benin'),
(1579, ':flag-bermuda:', 'flag-bermuda'),
(1580, ':flag-brunei:', 'flag-brunei'),
(1581, ':flag-bolivia:', 'flag-bolivia'),
(1582, ':flag-caribbean-netherlands:', 'flag-caribbean-netherlands'),
(1583, ':flag-brazil:', 'flag-brazil'),
(1584, ':flag-bahamas:', 'flag-bahamas'),
(1585, ':flag-bhutan:', 'flag-bhutan'),
(1586, ':flag-bouvet-island:', 'flag-bouvet-island'),
(1587, ':flag-botswana:', 'flag-botswana'),
(1588, ':flag-belarus:', 'flag-belarus'),
(1589, ':flag-belize:', 'flag-belize'),
(1590, ':flag-canada:', 'flag-canada'),
(1591, ':flag-cocos-keeling-islands:', 'flag-cocos-keeling-islands'),
(1592, ':flag-congo-kinshasa:', 'flag-congo-kinshasa'),
(1593, ':flag-central-african-republic:', 'flag-central-african-republic'),
(1594, ':flag-congo-brazzaville:', 'flag-congo-brazzaville'),
(1595, ':flag-switzerland:', 'flag-switzerland'),
(1596, ':flag-cook-islands:', 'flag-cook-islands'),
(1597, ':flag-chile:', 'flag-chile'),
(1598, ':flag-cameroon:', 'flag-cameroon'),
(1599, ':flag-china:', 'flag-china'),
(1600, ':flag-colombia:', 'flag-colombia'),
(1601, ':flag-clipperton-island:', 'flag-clipperton-island'),
(1602, ':flag-costa-rica:', 'flag-costa-rica'),
(1603, ':flag-cuba:', 'flag-cuba'),
(1604, ':flag-cape-verde:', 'flag-cape-verde'),
(1605, ':flag-christmas-island:', 'flag-christmas-island'),
(1606, ':flag-cyprus:', 'flag-cyprus'),
(1607, ':flag-czechia:', 'flag-czechia'),
(1608, ':flag-germany:', 'flag-germany'),
(1609, ':flag-diego-garcia:', 'flag-diego-garcia'),
(1610, ':flag-djibouti:', 'flag-djibouti'),
(1611, ':flag-denmark:', 'flag-denmark'),
(1612, ':flag-dominica:', 'flag-dominica'),
(1613, ':flag-dominican-republic:', 'flag-dominican-republic'),
(1614, ':flag-algeria:', 'flag-algeria'),
(1615, ':flag-ceuta-melilla:', 'flag-ceuta-melilla'),
(1616, ':flag-ecuador:', 'flag-ecuador'),
(1617, ':flag-estonia:', 'flag-estonia'),
(1618, ':flag-egypt:', 'flag-egypt'),
(1619, ':flag-western-sahara:', 'flag-western-sahara'),
(1620, ':flag-eritrea:', 'flag-eritrea'),
(1621, ':flag-spain:', 'flag-spain'),
(1622, ':flag-ethiopia:', 'flag-ethiopia'),
(1623, ':flag-european-union:', 'flag-european-union'),
(1624, ':flag-finland:', 'flag-finland'),
(1625, ':flag-fiji:', 'flag-fiji'),
(1626, ':flag-falkland-islands:', 'flag-falkland-islands'),
(1627, ':flag-micronesia:', 'flag-micronesia'),
(1628, ':flag-faroe-islands:', 'flag-faroe-islands'),
(1629, ':flag-france:', 'flag-france'),
(1630, ':flag-gabon:', 'flag-gabon'),
(1631, ':flag-united-kingdom:', 'flag-united-kingdom'),
(1632, ':flag-grenada:', 'flag-grenada'),
(1633, ':flag-georgia:', 'flag-georgia'),
(1634, ':flag-french-guiana:', 'flag-french-guiana'),
(1635, ':flag-guernsey:', 'flag-guernsey'),
(1636, ':flag-ghana:', 'flag-ghana'),
(1637, ':flag-gibraltar:', 'flag-gibraltar'),
(1638, ':flag-greenland:', 'flag-greenland'),
(1639, ':flag-gambia:', 'flag-gambia'),
(1640, ':flag-guinea:', 'flag-guinea'),
(1641, ':flag-guadeloupe:', 'flag-guadeloupe'),
(1642, ':flag-equatorial-guinea:', 'flag-equatorial-guinea'),
(1643, ':flag-greece:', 'flag-greece'),
(1644, ':flag-south-georgia-south-sandwich-islands:', 'flag-south-georgia-south-sandwich-islands'),
(1645, ':flag-guatemala:', 'flag-guatemala'),
(1646, ':flag-guam:', 'flag-guam'),
(1647, ':flag-guinea-bissau:', 'flag-guinea-bissau'),
(1648, ':flag-guyana:', 'flag-guyana'),
(1649, ':flag-hong-kong-sar-china:', 'flag-hong-kong-sar-china'),
(1650, ':flag-heard-mcdonald-islands:', 'flag-heard-mcdonald-islands'),
(1651, ':flag-honduras:', 'flag-honduras'),
(1652, ':flag-croatia:', 'flag-croatia'),
(1653, ':flag-haiti:', 'flag-haiti'),
(1654, ':flag-hungary:', 'flag-hungary'),
(1655, ':flag-canary-islands:', 'flag-canary-islands'),
(1656, ':flag-indonesia:', 'flag-indonesia'),
(1657, ':flag-ireland:', 'flag-ireland'),
(1658, ':flag-israel:', 'flag-israel'),
(1659, ':flag-isle-of-man:', 'flag-isle-of-man'),
(1660, ':flag-india:', 'flag-india'),
(1661, ':flag-british-indian-ocean-territory:', 'flag-british-indian-ocean-territory'),
(1662, ':flag-iraq:', 'flag-iraq'),
(1663, ':flag-iran:', 'flag-iran'),
(1664, ':flag-iceland:', 'flag-iceland'),
(1665, ':flag-italy:', 'flag-italy'),
(1666, ':flag-jersey:', 'flag-jersey'),
(1667, ':flag-jamaica:', 'flag-jamaica'),
(1668, ':flag-jordan:', 'flag-jordan'),
(1669, ':flag-japan:', 'flag-japan'),
(1670, ':flag-kenya:', 'flag-kenya'),
(1671, ':flag-kyrgyzstan:', 'flag-kyrgyzstan'),
(1672, ':flag-cambodia:', 'flag-cambodia'),
(1673, ':flag-kiribati:', 'flag-kiribati'),
(1674, ':flag-comoros:', 'flag-comoros'),
(1675, ':flag-north-korea:', 'flag-north-korea'),
(1676, ':flag-south-korea:', 'flag-south-korea'),
(1677, ':flag-kuwait:', 'flag-kuwait'),
(1678, ':flag-cayman-islands:', 'flag-cayman-islands'),
(1679, ':flag-kazakhstan:', 'flag-kazakhstan'),
(1680, ':flag-laos:', 'flag-laos'),
(1681, ':flag-lebanon:', 'flag-lebanon'),
(1682, ':flag-liechtenstein:', 'flag-liechtenstein'),
(1683, ':flag-sri-lanka:', 'flag-sri-lanka'),
(1684, ':flag-liberia:', 'flag-liberia'),
(1685, ':flag-lesotho:', 'flag-lesotho'),
(1686, ':flag-lithuania:', 'flag-lithuania'),
(1687, ':flag-luxembourg:', 'flag-luxembourg'),
(1688, ':flag-latvia:', 'flag-latvia'),
(1689, ':flag-libya:', 'flag-libya'),
(1690, ':flag-morocco:', 'flag-morocco'),
(1691, ':flag-monaco:', 'flag-monaco'),
(1692, ':flag-moldova:', 'flag-moldova'),
(1693, ':flag-montenegro:', 'flag-montenegro'),
(1694, ':flag-madagascar:', 'flag-madagascar'),
(1695, ':flag-marshall-islands:', 'flag-marshall-islands'),
(1696, ':flag-north-macedonia:', 'flag-north-macedonia'),
(1697, ':flag-mali:', 'flag-mali'),
(1698, ':flag-myanmar-burma:', 'flag-myanmar-burma'),
(1699, ':flag-mongolia:', 'flag-mongolia'),
(1700, ':flag-macao-sar-china:', 'flag-macao-sar-china'),
(1701, ':flag-northern-mariana-islands:', 'flag-northern-mariana-islands'),
(1702, ':flag-martinique:', 'flag-martinique'),
(1703, ':flag-mauritania:', 'flag-mauritania'),
(1704, ':flag-montserrat:', 'flag-montserrat'),
(1705, ':flag-malta:', 'flag-malta'),
(1706, ':flag-mauritius:', 'flag-mauritius'),
(1707, ':flag-maldives:', 'flag-maldives'),
(1708, ':flag-malawi:', 'flag-malawi'),
(1709, ':flag-mexico:', 'flag-mexico'),
(1710, ':flag-malaysia:', 'flag-malaysia'),
(1711, ':flag-mozambique:', 'flag-mozambique'),
(1712, ':flag-namibia:', 'flag-namibia'),
(1713, ':flag-new-caledonia:', 'flag-new-caledonia'),
(1714, ':flag-niger:', 'flag-niger'),
(1715, ':flag-norfolk-island:', 'flag-norfolk-island'),
(1716, ':flag-nigeria:', 'flag-nigeria'),
(1717, ':flag-nicaragua:', 'flag-nicaragua'),
(1718, ':flag-netherlands:', 'flag-netherlands'),
(1719, ':flag-norway:', 'flag-norway'),
(1720, ':flag-nepal:', 'flag-nepal'),
(1721, ':flag-nauru:', 'flag-nauru'),
(1722, ':flag-niue:', 'flag-niue'),
(1723, ':flag-new-zealand:', 'flag-new-zealand'),
(1724, ':flag-oman:', 'flag-oman'),
(1725, ':flag-panama:', 'flag-panama'),
(1726, ':flag-peru:', 'flag-peru'),
(1727, ':flag-french-polynesia:', 'flag-french-polynesia'),
(1728, ':flag-papua-new-guinea:', 'flag-papua-new-guinea'),
(1729, ':flag-philippines:', 'flag-philippines'),
(1730, ':flag-pakistan:', 'flag-pakistan'),
(1731, ':flag-poland:', 'flag-poland'),
(1732, ':flag-pitcairn-islands:', 'flag-pitcairn-islands'),
(1733, ':flag-puerto-rico:', 'flag-puerto-rico'),
(1734, ':flag-palestinian-territories:', 'flag-palestinian-territories'),
(1735, ':flag-portugal:', 'flag-portugal'),
(1736, ':flag-palau:', 'flag-palau'),
(1737, ':flag-paraguay:', 'flag-paraguay'),
(1738, ':flag-qatar:', 'flag-qatar'),
(1739, ':flag-romania:', 'flag-romania'),
(1740, ':flag-serbia:', 'flag-serbia'),
(1741, ':flag-russia:', 'flag-russia'),
(1742, ':flag-rwanda:', 'flag-rwanda'),
(1743, ':flag-saudi-arabia:', 'flag-saudi-arabia'),
(1744, ':flag-solomon-islands:', 'flag-solomon-islands'),
(1745, ':flag-seychelles:', 'flag-seychelles'),
(1746, ':flag-sudan:', 'flag-sudan'),
(1747, ':flag-sweden:', 'flag-sweden'),
(1748, ':flag-singapore:', 'flag-singapore'),
(1749, ':flag-slovenia:', 'flag-slovenia'),
(1750, ':flag-svalbard-jan-mayen:', 'flag-svalbard-jan-mayen'),
(1751, ':flag-slovakia:', 'flag-slovakia'),
(1752, ':flag-sierra-leone:', 'flag-sierra-leone'),
(1753, ':flag-san-marino:', 'flag-san-marino'),
(1754, ':flag-senegal:', 'flag-senegal'),
(1755, ':flag-somalia:', 'flag-somalia'),
(1756, ':flag-suriname:', 'flag-suriname'),
(1757, ':flag-south-sudan:', 'flag-south-sudan'),
(1758, ':flag-el-salvador:', 'flag-el-salvador'),
(1759, ':flag-sint-maarten:', 'flag-sint-maarten'),
(1760, ':flag-syria:', 'flag-syria'),
(1761, ':flag-eswatini:', 'flag-eswatini'),
(1762, ':flag-tristan-da-cunha:', 'flag-tristan-da-cunha'),
(1763, ':flag-turks-caicos-islands:', 'flag-turks-caicos-islands'),
(1764, ':flag-chad:', 'flag-chad'),
(1765, ':flag-french-southern-territories:', 'flag-french-southern-territories'),
(1766, ':flag-togo:', 'flag-togo'),
(1767, ':flag-thailand:', 'flag-thailand'),
(1768, ':flag-tajikistan:', 'flag-tajikistan'),
(1769, ':flag-tokelau:', 'flag-tokelau'),
(1770, ':flag-timor-leste:', 'flag-timor-leste'),
(1771, ':flag-turkmenistan:', 'flag-turkmenistan'),
(1772, ':flag-tunisia:', 'flag-tunisia'),
(1773, ':flag-tonga:', 'flag-tonga'),
(1774, ':flag-turkey:', 'flag-turkey'),
(1775, ':flag-trinidad-tobago:', 'flag-trinidad-tobago'),
(1776, ':flag-tuvalu:', 'flag-tuvalu'),
(1777, ':flag-taiwan:', 'flag-taiwan'),
(1778, ':flag-tanzania:', 'flag-tanzania'),
(1779, ':flag-ukraine:', 'flag-ukraine'),
(1780, ':flag-uganda:', 'flag-uganda'),
(1781, ':flag-u-s-outlying-islands:', 'flag-u-s-outlying-islands'),
(1782, ':flag-united-nations:', 'flag-united-nations'),
(1783, ':flag-united-states:', 'flag-united-states'),
(1784, ':flag-uruguay:', 'flag-uruguay'),
(1785, ':flag-uzbekistan:', 'flag-uzbekistan'),
(1786, ':flag-vatican-city:', 'flag-vatican-city'),
(1787, ':flag-venezuela:', 'flag-venezuela'),
(1788, ':flag-british-virgin-islands:', 'flag-british-virgin-islands'),
(1789, ':flag-u-s-virgin-islands:', 'flag-u-s-virgin-islands'),
(1790, ':flag-vietnam:', 'flag-vietnam'),
(1791, ':flag-vanuatu:', 'flag-vanuatu'),
(1792, ':flag-wallis-futuna:', 'flag-wallis-futuna'),
(1793, ':flag-samoa:', 'flag-samoa'),
(1794, ':flag-kosovo:', 'flag-kosovo'),
(1795, ':flag-yemen:', 'flag-yemen'),
(1796, ':flag-mayotte:', 'flag-mayotte'),
(1797, ':flag-south-africa:', 'flag-south-africa'),
(1798, ':flag-zambia:', 'flag-zambia'),
(1799, ':flag-zimbabwe:', 'flag-zimbabwe'),
(1800, ':flag-england:', 'flag-england'),
(1801, ':flag-scotland:', 'flag-scotland'),
(1802, ':flag-wales:', 'flag-wales');

-- --------------------------------------------------------

--
-- Table structure for table `events`
--

DROP TABLE IF EXISTS `events`;
CREATE TABLE IF NOT EXISTS `events` (
  `event_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `event_privacy` enum('secret','closed','public') DEFAULT 'public',
  `event_admin` int(10) UNSIGNED NOT NULL,
  `event_category` int(10) UNSIGNED NOT NULL,
  `event_title` varchar(256) NOT NULL,
  `event_location` varchar(256) DEFAULT NULL,
  `event_description` mediumtext NOT NULL,
  `event_start_date` datetime NOT NULL,
  `event_end_date` datetime NOT NULL,
  `event_publish_enabled` enum('0','1') NOT NULL DEFAULT '1',
  `event_publish_approval_enabled` enum('0','1') NOT NULL DEFAULT '0',
  `event_cover` varchar(256) DEFAULT NULL,
  `event_cover_id` int(10) UNSIGNED DEFAULT NULL,
  `event_cover_position` varchar(256) DEFAULT NULL,
  `event_album_covers` int(10) DEFAULT NULL,
  `event_album_timeline` int(10) DEFAULT NULL,
  `event_pinned_post` int(10) DEFAULT NULL,
  `event_invited` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `event_interested` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `event_going` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `event_date` datetime NOT NULL,
  PRIMARY KEY (`event_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `events_categories`
--

DROP TABLE IF EXISTS `events_categories`;
CREATE TABLE IF NOT EXISTS `events_categories` (
  `category_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `category_parent_id` int(10) UNSIGNED NOT NULL,
  `category_name` varchar(256) NOT NULL,
  `category_description` text NOT NULL,
  `category_order` int(10) UNSIGNED NOT NULL DEFAULT '1',
  PRIMARY KEY (`category_id`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `events_categories`
--

INSERT INTO `events_categories` (`category_id`, `category_parent_id`, `category_name`, `category_description`, `category_order`) VALUES
(1, 0, 'Art', '', 1),
(2, 0, 'Causes', '', 2),
(3, 0, 'Crafts', '', 3),
(4, 0, 'Dance', '', 4),
(5, 0, 'Drinks', '', 5),
(6, 0, 'Film', '', 6),
(7, 0, 'Fitness', '', 7),
(8, 0, 'Food', '', 8),
(9, 0, 'Games', '', 9),
(10, 0, 'Gardening', '', 10),
(11, 0, 'Health', '', 11),
(12, 0, 'Home', '', 12),
(13, 0, 'Literature', '', 13),
(14, 0, 'Music', '', 14),
(15, 0, 'Networking', '', 15),
(16, 0, 'Other', '', 16),
(17, 0, 'Party', '', 17),
(18, 0, 'Religion', '', 18),
(19, 0, 'Shopping', '', 19),
(20, 0, 'Sports', '', 20),
(21, 0, 'Theater', '', 21),
(22, 0, 'Wellness', '', 22);

-- --------------------------------------------------------

--
-- Table structure for table `events_members`
--

DROP TABLE IF EXISTS `events_members`;
CREATE TABLE IF NOT EXISTS `events_members` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `event_id` int(10) UNSIGNED NOT NULL,
  `user_id` int(10) UNSIGNED NOT NULL,
  `is_invited` enum('0','1') DEFAULT '0',
  `is_interested` enum('0','1') DEFAULT '0',
  `is_going` enum('0','1') DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `group_id_user_id` (`event_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `followings`
--

DROP TABLE IF EXISTS `followings`;
CREATE TABLE IF NOT EXISTS `followings` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` int(10) UNSIGNED NOT NULL,
  `following_id` int(10) UNSIGNED NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id_following_id` (`user_id`,`following_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `forums`
--

DROP TABLE IF EXISTS `forums`;
CREATE TABLE IF NOT EXISTS `forums` (
  `forum_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `forum_section` int(10) UNSIGNED NOT NULL,
  `forum_name` varchar(256) NOT NULL,
  `forum_description` mediumtext,
  `forum_order` int(10) UNSIGNED NOT NULL DEFAULT '1',
  `forum_threads` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `forum_replies` int(10) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`forum_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `forums_replies`
--

DROP TABLE IF EXISTS `forums_replies`;
CREATE TABLE IF NOT EXISTS `forums_replies` (
  `reply_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `thread_id` int(10) UNSIGNED NOT NULL,
  `user_id` int(10) UNSIGNED NOT NULL,
  `text` longtext NOT NULL,
  `time` datetime NOT NULL,
  PRIMARY KEY (`reply_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `forums_threads`
--

DROP TABLE IF EXISTS `forums_threads`;
CREATE TABLE IF NOT EXISTS `forums_threads` (
  `thread_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `forum_id` int(10) UNSIGNED NOT NULL,
  `user_id` int(10) UNSIGNED NOT NULL,
  `title` varchar(256) NOT NULL,
  `text` longtext NOT NULL,
  `replies` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `views` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `time` datetime NOT NULL,
  `last_reply` datetime DEFAULT NULL,
  PRIMARY KEY (`thread_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `friends`
--

DROP TABLE IF EXISTS `friends`;
CREATE TABLE IF NOT EXISTS `friends` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_one_id` int(10) UNSIGNED NOT NULL,
  `user_two_id` int(10) UNSIGNED NOT NULL,
  `status` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_one_id_user_two_id` (`user_one_id`,`user_two_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `funding_payments`
--

DROP TABLE IF EXISTS `funding_payments`;
CREATE TABLE IF NOT EXISTS `funding_payments` (
  `payment_id` int(10) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) UNSIGNED NOT NULL,
  `amount` varchar(32) NOT NULL,
  `method` varchar(64) NOT NULL,
  `method_value` text NOT NULL,
  `time` datetime NOT NULL,
  `status` tinyint(1) NOT NULL,
  PRIMARY KEY (`payment_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `games`
--

DROP TABLE IF EXISTS `games`;
CREATE TABLE IF NOT EXISTS `games` (
  `game_id` int(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(256) NOT NULL,
  `description` mediumtext NOT NULL,
  `source` mediumtext NOT NULL,
  `thumbnail` varchar(256) NOT NULL,
  PRIMARY KEY (`game_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `games_players`
--

DROP TABLE IF EXISTS `games_players`;
CREATE TABLE IF NOT EXISTS `games_players` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `game_id` int(10) UNSIGNED NOT NULL,
  `user_id` int(10) UNSIGNED NOT NULL,
  `last_played_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `game_id_user_id` (`game_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `gifts`
--

DROP TABLE IF EXISTS `gifts`;
CREATE TABLE IF NOT EXISTS `gifts` (
  `gift_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `image` varchar(256) NOT NULL,
  PRIMARY KEY (`gift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `groups`
--

DROP TABLE IF EXISTS `groups`;
CREATE TABLE IF NOT EXISTS `groups` (
  `group_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `group_privacy` enum('secret','closed','public') DEFAULT 'public',
  `group_admin` int(10) UNSIGNED NOT NULL,
  `group_category` int(10) UNSIGNED NOT NULL,
  `group_name` varchar(64) NOT NULL,
  `group_title` varchar(256) NOT NULL,
  `group_description` mediumtext NOT NULL,
  `group_publish_enabled` enum('0','1') NOT NULL DEFAULT '1',
  `group_publish_approval_enabled` enum('0','1') NOT NULL DEFAULT '0',
  `group_picture` varchar(256) DEFAULT NULL,
  `group_picture_id` int(10) UNSIGNED DEFAULT NULL,
  `group_cover` varchar(256) DEFAULT NULL,
  `group_cover_id` int(10) UNSIGNED DEFAULT NULL,
  `group_cover_position` varchar(256) DEFAULT NULL,
  `group_album_pictures` int(10) DEFAULT NULL,
  `group_album_covers` int(10) DEFAULT NULL,
  `group_album_timeline` int(10) DEFAULT NULL,
  `group_pinned_post` int(10) DEFAULT NULL,
  `group_members` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `group_date` datetime NOT NULL,
  PRIMARY KEY (`group_id`),
  UNIQUE KEY `username` (`group_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `groups_admins`
--

DROP TABLE IF EXISTS `groups_admins`;
CREATE TABLE IF NOT EXISTS `groups_admins` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `group_id` int(10) UNSIGNED NOT NULL,
  `user_id` int(10) UNSIGNED NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `group_id_user_id` (`group_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `groups_categories`
--

DROP TABLE IF EXISTS `groups_categories`;
CREATE TABLE IF NOT EXISTS `groups_categories` (
  `category_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `category_parent_id` int(10) UNSIGNED NOT NULL,
  `category_name` varchar(256) NOT NULL,
  `category_description` text NOT NULL,
  `category_order` int(10) UNSIGNED NOT NULL DEFAULT '1',
  PRIMARY KEY (`category_id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `groups_categories`
--

INSERT INTO `groups_categories` (`category_id`, `category_parent_id`, `category_name`, `category_description`, `category_order`) VALUES
(1, 0, 'Cars and Vehicles', '', 1),
(2, 0, 'Comedy', '', 2),
(3, 0, 'Economics and Trade', '', 3),
(4, 0, 'Education', '', 4),
(5, 0, 'Entertainment', '', 5),
(6, 0, 'Movies and Animation', '', 6),
(7, 0, 'Gaming', '', 7),
(8, 0, 'History and Facts', '', 8),
(9, 0, 'Live Style', '', 9),
(10, 0, 'Natural', '', 10),
(11, 0, 'News and Politics', '', 11),
(12, 0, 'People and Nations', '', 12),
(13, 0, 'Pets and Animals', '', 13),
(14, 0, 'Places and Regions', '', 14),
(15, 0, 'Science and Technology', '', 15),
(16, 0, 'Sport', '', 16),
(17, 0, 'Travel and Events', '', 17),
(18, 0, 'Other', '', 18);

-- --------------------------------------------------------

--
-- Table structure for table `groups_members`
--

DROP TABLE IF EXISTS `groups_members`;
CREATE TABLE IF NOT EXISTS `groups_members` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `group_id` int(10) UNSIGNED NOT NULL,
  `user_id` int(10) UNSIGNED NOT NULL,
  `approved` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `group_id_user_id` (`group_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `hashtags`
--

DROP TABLE IF EXISTS `hashtags`;
CREATE TABLE IF NOT EXISTS `hashtags` (
  `hashtag_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `hashtag` varchar(256) NOT NULL,
  PRIMARY KEY (`hashtag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `hashtags_posts`
--

DROP TABLE IF EXISTS `hashtags_posts`;
CREATE TABLE IF NOT EXISTS `hashtags_posts` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `post_id` int(10) UNSIGNED NOT NULL,
  `hashtag_id` int(10) UNSIGNED NOT NULL,
  `created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `post_id_hashtag_id` (`post_id`,`hashtag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `invitation_codes`
--

DROP TABLE IF EXISTS `invitation_codes`;
CREATE TABLE IF NOT EXISTS `invitation_codes` (
  `code_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `code` varchar(64) NOT NULL,
  `created_by` int(10) UNSIGNED NOT NULL,
  `created_date` datetime NOT NULL,
  `used_by` int(10) UNSIGNED NOT NULL,
  `used_date` datetime NOT NULL,
  `used` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`code_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `jobs_categories`
--

DROP TABLE IF EXISTS `jobs_categories`;
CREATE TABLE IF NOT EXISTS `jobs_categories` (
  `category_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `category_parent_id` int(10) UNSIGNED NOT NULL,
  `category_name` varchar(256) NOT NULL,
  `category_description` text NOT NULL,
  `category_order` int(10) UNSIGNED NOT NULL DEFAULT '1',
  PRIMARY KEY (`category_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `jobs_categories`
--

INSERT INTO `jobs_categories` (`category_id`, `category_parent_id`, `category_name`, `category_description`, `category_order`) VALUES
(1, 0, 'Admin &amp; Office', '', 1),
(2, 0, 'Art &amp; Design', '', 2),
(3, 0, 'Business Operations', '', 3),
(4, 0, 'Cleaning &amp; Facilities', '', 4),
(5, 0, 'Community &amp; Social Services', '', 5),
(6, 0, 'Computer &amp; Data', '', 6),
(7, 0, 'Construction &amp; Mining', '', 7),
(8, 0, 'Education', '', 8),
(9, 0, 'Farming &amp; Forestry', '', 9),
(10, 0, 'Healthcare', '', 10),
(11, 0, 'Installation, Maintenance &amp; Repair', '', 11),
(12, 0, 'Legal', '', 12),
(13, 0, 'Management', '', 13),
(14, 0, 'Manufacturing', '', 14),
(15, 0, 'Media &amp; Communication', '', 15),
(16, 0, 'Personal Care', '', 16),
(17, 0, 'Protective Services', '', 17),
(18, 0, 'Restaurant &amp; Hospitality', '', 18),
(19, 0, 'Retail &amp; Sales', '', 19),
(20, 0, 'Science &amp; Engineering', '', 20),
(21, 0, 'Sports &amp; Entertainment', '', 21),
(22, 0, 'Transportation', '', 22),
(23, 0, 'Other', '', 23);

-- --------------------------------------------------------

--
-- Table structure for table `market_categories`
--

DROP TABLE IF EXISTS `market_categories`;
CREATE TABLE IF NOT EXISTS `market_categories` (
  `category_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `category_parent_id` int(10) UNSIGNED NOT NULL,
  `category_name` varchar(256) NOT NULL,
  `category_description` text NOT NULL,
  `category_order` int(10) UNSIGNED NOT NULL DEFAULT '1',
  PRIMARY KEY (`category_id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `market_categories`
--

INSERT INTO `market_categories` (`category_id`, `category_parent_id`, `category_name`, `category_description`, `category_order`) VALUES
(1, 0, 'Apparel &amp; Accessories', '', 1),
(2, 0, 'Autos &amp; Vehicles', '', 2),
(3, 0, 'Baby &amp; Children&#039;s Products', '', 3),
(4, 0, 'Beauty Products &amp; Services', '', 4),
(5, 0, 'Computers &amp; Peripherals', '', 5),
(6, 0, 'Consumer Electronics', '', 6),
(7, 0, 'Dating Services', '', 7),
(8, 0, 'Financial Services', '', 8),
(9, 0, 'Gifts &amp; Occasions', '', 9),
(10, 0, 'Home &amp; Garden', '', 10),
(11, 0, 'Other', '', 11);

-- --------------------------------------------------------

--
-- Table structure for table `movies`
--

DROP TABLE IF EXISTS `movies`;
CREATE TABLE IF NOT EXISTS `movies` (
  `movie_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `source` text NOT NULL,
  `source_type` varchar(64) NOT NULL,
  `title` varchar(256) NOT NULL,
  `description` text,
  `imdb_url` text,
  `stars` text,
  `release_year` int(10) DEFAULT NULL,
  `duration` int(10) DEFAULT NULL,
  `genres` mediumtext,
  `poster` varchar(256) DEFAULT NULL,
  `views` int(10) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`movie_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `movies_genres`
--

DROP TABLE IF EXISTS `movies_genres`;
CREATE TABLE IF NOT EXISTS `movies_genres` (
  `genre_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `genre_name` varchar(256) NOT NULL,
  `genre_description` text NOT NULL,
  `genre_order` int(10) UNSIGNED NOT NULL DEFAULT '1',
  PRIMARY KEY (`genre_id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `movies_genres`
--

INSERT INTO `movies_genres` (`genre_id`, `genre_name`, `genre_description`, `genre_order`) VALUES
(1, 'Action', '', 1),
(2, 'Adventure', '', 2),
(3, 'Animation', '', 3),
(4, 'Comedy', '', 4),
(5, 'Crime', '', 5),
(6, 'Documentary', '', 6),
(7, 'Drama', '', 7),
(8, 'Family', '', 8),
(9, 'Fantasy', '', 9),
(10, 'History', '', 10),
(11, 'Horror', '', 11),
(12, 'Musical', '', 12),
(13, 'Mythological', '', 13),
(14, 'Romance', '', 14),
(15, 'Sport', '', 15),
(16, 'TV Show', '', 16),
(17, 'Thriller', '', 17),
(18, 'War', '', 18);

-- --------------------------------------------------------

--
-- Table structure for table `notifications`
--

DROP TABLE IF EXISTS `notifications`;
CREATE TABLE IF NOT EXISTS `notifications` (
  `notification_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `to_user_id` int(10) UNSIGNED NOT NULL,
  `from_user_id` int(10) UNSIGNED NOT NULL,
  `from_user_type` enum('user','page') NOT NULL DEFAULT 'user',
  `action` varchar(256) NOT NULL,
  `node_type` varchar(256) NOT NULL,
  `node_url` varchar(256) NOT NULL,
  `notify_id` varchar(256) DEFAULT NULL,
  `message` mediumtext,
  `time` datetime DEFAULT NULL,
  `seen` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`notification_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `offers_categories`
--

DROP TABLE IF EXISTS `offers_categories`;
CREATE TABLE IF NOT EXISTS `offers_categories` (
  `category_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `category_parent_id` int(10) UNSIGNED NOT NULL,
  `category_name` varchar(256) NOT NULL,
  `category_description` text NOT NULL,
  `category_order` int(10) UNSIGNED NOT NULL DEFAULT '1',
  PRIMARY KEY (`category_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `offers_categories`
--

INSERT INTO `offers_categories` (`category_id`, `category_parent_id`, `category_name`, `category_description`, `category_order`) VALUES
(1, 0, 'Apparel &amp; Accessories', '', 1),
(2, 0, 'Autos &amp; Vehicles', '', 2),
(3, 0, 'Baby &amp; Children&#039;s Products', '', 3),
(4, 0, 'Beauty Products &amp; Services', '', 4),
(5, 0, 'Computers &amp; Peripherals', '', 5),
(6, 0, 'Consumer Electronics', '', 6),
(7, 0, 'Dating Services', '', 7),
(8, 0, 'Financial Services', '', 8),
(9, 0, 'Gifts &amp; Occasions', '', 9),
(10, 0, 'Home &amp; Garden', '', 10),
(11, 0, 'Other', '', 11);

-- --------------------------------------------------------

--
-- Table structure for table `packages`
--

DROP TABLE IF EXISTS `packages`;
CREATE TABLE IF NOT EXISTS `packages` (
  `package_id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(256) NOT NULL,
  `price` varchar(32) NOT NULL,
  `period_num` int(10) UNSIGNED NOT NULL,
  `period` varchar(32) NOT NULL,
  `color` varchar(32) NOT NULL,
  `icon` varchar(256) NOT NULL,
  `verification_badge_enabled` enum('0','1') NOT NULL DEFAULT '0',
  `boost_posts_enabled` enum('0','1') NOT NULL DEFAULT '0',
  `boost_posts` int(10) UNSIGNED NOT NULL,
  `boost_pages_enabled` enum('0','1') NOT NULL DEFAULT '0',
  `boost_pages` int(10) UNSIGNED NOT NULL,
  PRIMARY KEY (`package_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `packages_payments`
--

DROP TABLE IF EXISTS `packages_payments`;
CREATE TABLE IF NOT EXISTS `packages_payments` (
  `payment_id` int(10) NOT NULL AUTO_INCREMENT,
  `payment_date` datetime NOT NULL,
  `package_name` varchar(256) NOT NULL,
  `package_price` varchar(32) NOT NULL,
  PRIMARY KEY (`payment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `pages`
--

DROP TABLE IF EXISTS `pages`;
CREATE TABLE IF NOT EXISTS `pages` (
  `page_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `page_admin` int(10) UNSIGNED NOT NULL,
  `page_category` int(10) UNSIGNED NOT NULL,
  `page_name` varchar(64) NOT NULL,
  `page_title` varchar(256) NOT NULL,
  `page_picture` varchar(256) DEFAULT NULL,
  `page_picture_id` int(10) UNSIGNED DEFAULT NULL,
  `page_cover` varchar(256) DEFAULT NULL,
  `page_cover_id` int(10) UNSIGNED DEFAULT NULL,
  `page_cover_position` varchar(256) DEFAULT NULL,
  `page_album_pictures` int(10) UNSIGNED DEFAULT NULL,
  `page_album_covers` int(10) UNSIGNED DEFAULT NULL,
  `page_album_timeline` int(10) UNSIGNED DEFAULT NULL,
  `page_pinned_post` int(10) UNSIGNED DEFAULT NULL,
  `page_verified` enum('0','1') NOT NULL DEFAULT '0',
  `page_boosted` enum('0','1') NOT NULL DEFAULT '0',
  `page_boosted_by` int(10) UNSIGNED DEFAULT NULL,
  `page_company` varchar(256) DEFAULT NULL,
  `page_phone` varchar(256) DEFAULT NULL,
  `page_website` varchar(256) DEFAULT NULL,
  `page_location` varchar(256) DEFAULT NULL,
  `page_description` mediumtext NOT NULL,
  `page_action_text` varchar(32) DEFAULT NULL,
  `page_action_color` varchar(32) DEFAULT NULL,
  `page_action_url` varchar(256) DEFAULT NULL,
  `page_social_facebook` varchar(256) DEFAULT NULL,
  `page_social_twitter` varchar(256) DEFAULT NULL,
  `page_social_youtube` varchar(256) DEFAULT NULL,
  `page_social_instagram` varchar(256) DEFAULT NULL,
  `page_social_linkedin` varchar(256) DEFAULT NULL,
  `page_social_vkontakte` varchar(256) DEFAULT NULL,
  `page_likes` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `page_date` datetime NOT NULL,
  PRIMARY KEY (`page_id`),
  UNIQUE KEY `username` (`page_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `pages_admins`
--

DROP TABLE IF EXISTS `pages_admins`;
CREATE TABLE IF NOT EXISTS `pages_admins` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `page_id` int(10) UNSIGNED NOT NULL,
  `user_id` int(10) UNSIGNED NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `page_id_user_id` (`page_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `pages_categories`
--

DROP TABLE IF EXISTS `pages_categories`;
CREATE TABLE IF NOT EXISTS `pages_categories` (
  `category_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `category_parent_id` int(10) UNSIGNED NOT NULL,
  `category_name` varchar(256) NOT NULL,
  `category_description` text NOT NULL,
  `category_order` int(10) UNSIGNED NOT NULL DEFAULT '1',
  PRIMARY KEY (`category_id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `pages_categories`
--

INSERT INTO `pages_categories` (`category_id`, `category_parent_id`, `category_name`, `category_description`, `category_order`) VALUES
(1, 0, 'Cars and Vehicles', '', 1),
(2, 0, 'Comedy', '', 2),
(3, 0, 'Economics and Trade', '', 3),
(4, 0, 'Education', '', 4),
(5, 0, 'Entertainment', '', 5),
(6, 0, 'Movies and Animation', '', 6),
(7, 0, 'Gaming', '', 7),
(8, 0, 'History and Facts', '', 8),
(9, 0, 'Live Style', '', 9),
(10, 0, 'Natural', '', 10),
(11, 0, 'News and Politics', '', 11),
(12, 0, 'People and Nations', '', 12),
(13, 0, 'Pets and Animals', '', 13),
(14, 0, 'Places and Regions', '', 14),
(15, 0, 'Science and Technology', '', 15),
(16, 0, 'Sport', '', 16),
(17, 0, 'Travel and Events', '', 17),
(18, 0, 'Other', '', 18);

-- --------------------------------------------------------

--
-- Table structure for table `pages_invites`
--

DROP TABLE IF EXISTS `pages_invites`;
CREATE TABLE IF NOT EXISTS `pages_invites` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `page_id` int(10) UNSIGNED NOT NULL,
  `user_id` int(10) UNSIGNED NOT NULL,
  `from_user_id` int(10) UNSIGNED NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `page_id_user_id_from_user_id` (`page_id`,`user_id`,`from_user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `pages_likes`
--

DROP TABLE IF EXISTS `pages_likes`;
CREATE TABLE IF NOT EXISTS `pages_likes` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `page_id` int(10) UNSIGNED NOT NULL,
  `user_id` int(10) UNSIGNED NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `page_id_user_id` (`page_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `points_payments`
--

DROP TABLE IF EXISTS `points_payments`;
CREATE TABLE IF NOT EXISTS `points_payments` (
  `payment_id` int(10) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) UNSIGNED NOT NULL,
  `amount` varchar(32) NOT NULL,
  `method` varchar(64) NOT NULL,
  `method_value` text NOT NULL,
  `time` datetime NOT NULL,
  `status` tinyint(1) NOT NULL,
  PRIMARY KEY (`payment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `posts`
--

DROP TABLE IF EXISTS `posts`;
CREATE TABLE IF NOT EXISTS `posts` (
  `post_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` int(10) UNSIGNED NOT NULL,
  `user_type` enum('user','page') NOT NULL,
  `in_group` enum('0','1') NOT NULL DEFAULT '0',
  `group_id` int(10) UNSIGNED DEFAULT NULL,
  `group_approved` enum('0','1') NOT NULL DEFAULT '1',
  `in_event` enum('0','1') NOT NULL DEFAULT '0',
  `event_id` int(10) UNSIGNED DEFAULT NULL,
  `event_approved` enum('0','1') NOT NULL DEFAULT '1',
  `in_wall` enum('0','1') NOT NULL DEFAULT '0',
  `wall_id` int(10) UNSIGNED DEFAULT NULL,
  `post_type` varchar(32) NOT NULL,
  `colored_pattern` int(10) UNSIGNED DEFAULT NULL,
  `origin_id` int(10) UNSIGNED DEFAULT NULL,
  `time` datetime NOT NULL,
  `location` varchar(256) DEFAULT NULL,
  `privacy` varchar(32) NOT NULL,
  `text` longtext,
  `feeling_action` varchar(32) DEFAULT NULL,
  `feeling_value` varchar(256) DEFAULT NULL,
  `boosted` enum('0','1') NOT NULL DEFAULT '0',
  `boosted_by` int(10) UNSIGNED DEFAULT NULL,
  `comments_disabled` enum('0','1') NOT NULL DEFAULT '0',
  `is_hidden` enum('0','1') NOT NULL DEFAULT '0',
  `is_anonymous` enum('0','1') NOT NULL DEFAULT '0',
  `reaction_like_count` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `reaction_love_count` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `reaction_haha_count` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `reaction_yay_count` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `reaction_wow_count` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `reaction_sad_count` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `reaction_angry_count` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `comments` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `shares` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `points_earned` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `posts_articles`
--

DROP TABLE IF EXISTS `posts_articles`;
CREATE TABLE IF NOT EXISTS `posts_articles` (
  `article_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `post_id` int(10) UNSIGNED NOT NULL,
  `cover` varchar(256) NOT NULL,
  `title` varchar(256) NOT NULL,
  `text` longtext NOT NULL,
  `category_id` int(10) UNSIGNED NOT NULL,
  `tags` mediumtext NOT NULL,
  `views` int(10) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`article_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `posts_audios`
--

DROP TABLE IF EXISTS `posts_audios`;
CREATE TABLE IF NOT EXISTS `posts_audios` (
  `audio_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `post_id` int(10) UNSIGNED NOT NULL,
  `source` varchar(256) NOT NULL,
  `views` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`audio_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `posts_colored_patterns`
--

DROP TABLE IF EXISTS `posts_colored_patterns`;
CREATE TABLE IF NOT EXISTS `posts_colored_patterns` (
  `pattern_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `type` enum('color','image') NOT NULL DEFAULT 'color',
  `background_image` varchar(256) DEFAULT NULL,
  `background_color_1` varchar(32) DEFAULT NULL,
  `background_color_2` varchar(32) DEFAULT NULL,
  `text_color` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`pattern_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `posts_colored_patterns`
--

INSERT INTO `posts_colored_patterns` (`pattern_id`, `type`, `background_image`, `background_color_1`, `background_color_2`, `text_color`) VALUES
(1, 'image', 'patterns/1.jpg', NULL, NULL, '#FFFFFF'),
(2, 'image', 'patterns/2.jpg', NULL, NULL, '#FFFFFF'),
(3, 'image', 'patterns/3.jpg', NULL, NULL, '#FFFFFF'),
(4, 'image', 'patterns/4.jpg', '', '', '#000000'),
(5, 'image', 'patterns/5.jpg', NULL, NULL, '#FFFFFF'),
(6, 'color', NULL, '#FF00FF', '#030355', '#FFF300'),
(7, 'color', '', '#FF003D', '#D73A3A', '#FFFFFF');

-- --------------------------------------------------------

--
-- Table structure for table `posts_comments`
--

DROP TABLE IF EXISTS `posts_comments`;
CREATE TABLE IF NOT EXISTS `posts_comments` (
  `comment_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `node_id` int(10) UNSIGNED NOT NULL,
  `node_type` enum('post','photo','comment') NOT NULL,
  `user_id` int(10) UNSIGNED NOT NULL,
  `user_type` enum('user','page') NOT NULL,
  `text` longtext NOT NULL,
  `image` varchar(256) DEFAULT NULL,
  `voice_note` varchar(256) DEFAULT NULL,
  `time` datetime NOT NULL,
  `reaction_like_count` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `reaction_love_count` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `reaction_haha_count` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `reaction_yay_count` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `reaction_wow_count` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `reaction_sad_count` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `reaction_angry_count` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `replies` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `points_earned` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `posts_comments_reactions`
--

DROP TABLE IF EXISTS `posts_comments_reactions`;
CREATE TABLE IF NOT EXISTS `posts_comments_reactions` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `comment_id` int(10) UNSIGNED NOT NULL,
  `user_id` int(10) UNSIGNED NOT NULL,
  `reaction` varchar(32) DEFAULT 'like',
  `reaction_time` datetime DEFAULT NULL,
  `points_earned` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `comment_id_user_id` (`comment_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `posts_files`
--

DROP TABLE IF EXISTS `posts_files`;
CREATE TABLE IF NOT EXISTS `posts_files` (
  `file_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `post_id` int(10) UNSIGNED NOT NULL,
  `source` varchar(256) NOT NULL,
  PRIMARY KEY (`file_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `posts_funding`
--

DROP TABLE IF EXISTS `posts_funding`;
CREATE TABLE IF NOT EXISTS `posts_funding` (
  `funding_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `post_id` int(10) UNSIGNED NOT NULL,
  `title` varchar(256) NOT NULL,
  `amount` float NOT NULL DEFAULT '0',
  `raised_amount` float NOT NULL DEFAULT '0',
  `total_donations` int(10) NOT NULL DEFAULT '0',
  `cover_image` varchar(256) NOT NULL,
  PRIMARY KEY (`funding_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `posts_funding_donors`
--

DROP TABLE IF EXISTS `posts_funding_donors`;
CREATE TABLE IF NOT EXISTS `posts_funding_donors` (
  `donation_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` int(10) UNSIGNED NOT NULL,
  `post_id` int(10) UNSIGNED NOT NULL,
  `donation_amount` float UNSIGNED NOT NULL DEFAULT '0',
  `donation_time` datetime NOT NULL,
  PRIMARY KEY (`donation_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `posts_hidden`
--

DROP TABLE IF EXISTS `posts_hidden`;
CREATE TABLE IF NOT EXISTS `posts_hidden` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `post_id` int(10) UNSIGNED NOT NULL,
  `user_id` int(10) UNSIGNED NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `post_id_user_id` (`post_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `posts_jobs`
--

DROP TABLE IF EXISTS `posts_jobs`;
CREATE TABLE IF NOT EXISTS `posts_jobs` (
  `job_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `post_id` int(10) UNSIGNED NOT NULL,
  `category_id` int(10) UNSIGNED NOT NULL,
  `title` varchar(100) NOT NULL,
  `location` varchar(100) NOT NULL,
  `salary_minimum` varchar(100) NOT NULL,
  `salary_maximum` varchar(100) NOT NULL,
  `pay_salary_per` varchar(100) NOT NULL,
  `type` varchar(100) NOT NULL,
  `question_1_type` varchar(100) DEFAULT NULL,
  `question_1_title` varchar(256) DEFAULT NULL,
  `question_1_choices` text,
  `question_2_type` varchar(100) DEFAULT NULL,
  `question_2_title` varchar(256) DEFAULT NULL,
  `question_2_choices` text,
  `question_3_type` varchar(100) DEFAULT NULL,
  `question_3_title` varchar(256) DEFAULT NULL,
  `question_3_choices` text,
  `cover_image` varchar(256) NOT NULL,
  `available` enum('0','1') NOT NULL DEFAULT '1',
  PRIMARY KEY (`job_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `posts_jobs_applications`
--

DROP TABLE IF EXISTS `posts_jobs_applications`;
CREATE TABLE IF NOT EXISTS `posts_jobs_applications` (
  `application_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `post_id` int(10) UNSIGNED NOT NULL,
  `user_id` int(10) UNSIGNED NOT NULL,
  `name` varchar(100) NOT NULL,
  `location` varchar(100) NOT NULL,
  `phone` varchar(100) NOT NULL,
  `email` varchar(100) NOT NULL,
  `work_place` varchar(100) DEFAULT NULL,
  `work_position` varchar(100) DEFAULT NULL,
  `work_description` text,
  `work_from` varchar(100) DEFAULT NULL,
  `work_to` varchar(100) DEFAULT NULL,
  `work_now` enum('0','1') DEFAULT NULL,
  `question_1_answer` text,
  `question_2_answer` text,
  `question_3_answer` text,
  `applied_time` datetime NOT NULL,
  PRIMARY KEY (`application_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `posts_links`
--

DROP TABLE IF EXISTS `posts_links`;
CREATE TABLE IF NOT EXISTS `posts_links` (
  `link_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `post_id` int(10) UNSIGNED NOT NULL,
  `source_url` text NOT NULL,
  `source_host` varchar(256) NOT NULL,
  `source_title` varchar(256) NOT NULL,
  `source_text` mediumtext NOT NULL,
  `source_thumbnail` text NOT NULL,
  PRIMARY KEY (`link_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `posts_live`
--

DROP TABLE IF EXISTS `posts_live`;
CREATE TABLE IF NOT EXISTS `posts_live` (
  `live_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `post_id` int(10) UNSIGNED NOT NULL,
  `video_thumbnail` varchar(256) NOT NULL,
  `agora_uid` int(10) NOT NULL,
  `agora_channel_name` varchar(256) NOT NULL,
  `agora_resource_id` text,
  `agora_sid` varchar(256) DEFAULT NULL,
  `agora_file` text,
  `live_ended` enum('0','1') NOT NULL DEFAULT '0',
  `live_recorded` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`live_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `posts_live_users`
--

DROP TABLE IF EXISTS `posts_live_users`;
CREATE TABLE IF NOT EXISTS `posts_live_users` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` int(10) UNSIGNED NOT NULL,
  `post_id` int(10) UNSIGNED NOT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `user_id_post_id` (`user_id`,`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `posts_media`
--

DROP TABLE IF EXISTS `posts_media`;
CREATE TABLE IF NOT EXISTS `posts_media` (
  `media_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `post_id` int(10) NOT NULL,
  `source_url` mediumtext NOT NULL,
  `source_provider` varchar(256) NOT NULL,
  `source_type` varchar(256) NOT NULL,
  `source_title` varchar(256) DEFAULT NULL,
  `source_text` mediumtext,
  `source_html` mediumtext,
  `source_thumbnail` text,
  PRIMARY KEY (`media_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `posts_offers`
--

DROP TABLE IF EXISTS `posts_offers`;
CREATE TABLE IF NOT EXISTS `posts_offers` (
  `offer_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `post_id` int(10) UNSIGNED NOT NULL,
  `category_id` int(10) UNSIGNED NOT NULL,
  `title` varchar(100) NOT NULL,
  `discount_type` varchar(32) NOT NULL,
  `discount_percent` int(10) UNSIGNED NOT NULL,
  `discount_amount` varchar(100) NOT NULL,
  `buy_x` varchar(100) NOT NULL,
  `get_y` varchar(100) NOT NULL,
  `spend_x` varchar(100) NOT NULL,
  `amount_y` varchar(100) NOT NULL,
  `end_date` datetime NOT NULL,
  `thumbnail` varchar(256) NOT NULL,
  PRIMARY KEY (`offer_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `posts_photos`
--

DROP TABLE IF EXISTS `posts_photos`;
CREATE TABLE IF NOT EXISTS `posts_photos` (
  `photo_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `post_id` int(10) UNSIGNED NOT NULL,
  `album_id` int(10) UNSIGNED DEFAULT NULL,
  `source` varchar(256) NOT NULL,
  `blur` enum('0','1') NOT NULL DEFAULT '0',
  `reaction_like_count` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `reaction_love_count` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `reaction_haha_count` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `reaction_yay_count` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `reaction_wow_count` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `reaction_sad_count` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `reaction_angry_count` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `comments` int(10) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`photo_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `posts_photos_albums`
--

DROP TABLE IF EXISTS `posts_photos_albums`;
CREATE TABLE IF NOT EXISTS `posts_photos_albums` (
  `album_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` int(10) UNSIGNED NOT NULL,
  `user_type` enum('user','page') NOT NULL,
  `in_group` enum('0','1') NOT NULL DEFAULT '0',
  `group_id` int(10) UNSIGNED DEFAULT NULL,
  `in_event` enum('0','1') NOT NULL DEFAULT '0',
  `event_id` int(10) UNSIGNED DEFAULT NULL,
  `title` varchar(256) NOT NULL,
  `privacy` enum('me','friends','public','custom') NOT NULL DEFAULT 'public',
  PRIMARY KEY (`album_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `posts_photos_reactions`
--

DROP TABLE IF EXISTS `posts_photos_reactions`;
CREATE TABLE IF NOT EXISTS `posts_photos_reactions` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `photo_id` int(10) UNSIGNED NOT NULL,
  `user_id` int(10) UNSIGNED NOT NULL,
  `reaction` varchar(32) NOT NULL DEFAULT 'like',
  `reaction_time` datetime DEFAULT NULL,
  `points_earned` enum('0','1') DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id_photo_id` (`user_id`,`photo_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `posts_polls`
--

DROP TABLE IF EXISTS `posts_polls`;
CREATE TABLE IF NOT EXISTS `posts_polls` (
  `poll_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `post_id` int(10) UNSIGNED NOT NULL,
  `votes` int(10) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`poll_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `posts_polls_options`
--

DROP TABLE IF EXISTS `posts_polls_options`;
CREATE TABLE IF NOT EXISTS `posts_polls_options` (
  `option_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `poll_id` int(10) UNSIGNED NOT NULL,
  `text` varchar(256) NOT NULL,
  PRIMARY KEY (`option_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `posts_polls_options_users`
--

DROP TABLE IF EXISTS `posts_polls_options_users`;
CREATE TABLE IF NOT EXISTS `posts_polls_options_users` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` int(10) UNSIGNED NOT NULL,
  `poll_id` int(10) UNSIGNED NOT NULL,
  `option_id` int(10) UNSIGNED NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id_poll_id` (`user_id`,`poll_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `posts_products`
--

DROP TABLE IF EXISTS `posts_products`;
CREATE TABLE IF NOT EXISTS `posts_products` (
  `product_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `post_id` int(10) UNSIGNED NOT NULL,
  `name` varchar(256) NOT NULL,
  `price` float NOT NULL DEFAULT '0',
  `category_id` int(10) UNSIGNED NOT NULL,
  `status` enum('new','old') NOT NULL DEFAULT 'new',
  `location` varchar(255) NOT NULL,
  `available` enum('0','1') NOT NULL DEFAULT '1',
  PRIMARY KEY (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `posts_reactions`
--

DROP TABLE IF EXISTS `posts_reactions`;
CREATE TABLE IF NOT EXISTS `posts_reactions` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `post_id` int(10) UNSIGNED NOT NULL,
  `user_id` int(10) UNSIGNED NOT NULL,
  `reaction` varchar(32) NOT NULL DEFAULT 'like',
  `reaction_time` datetime DEFAULT NULL,
  `points_earned` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `post_id_user_id` (`post_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `posts_saved`
--

DROP TABLE IF EXISTS `posts_saved`;
CREATE TABLE IF NOT EXISTS `posts_saved` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `post_id` int(10) UNSIGNED NOT NULL,
  `user_id` int(10) UNSIGNED NOT NULL,
  `time` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `post_id_user_id` (`post_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `posts_videos`
--

DROP TABLE IF EXISTS `posts_videos`;
CREATE TABLE IF NOT EXISTS `posts_videos` (
  `video_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `post_id` int(10) UNSIGNED NOT NULL,
  `source` varchar(256) NOT NULL,
  `thumbnail` varchar(256) DEFAULT NULL,
  `views` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`video_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `reports`
--

DROP TABLE IF EXISTS `reports`;
CREATE TABLE IF NOT EXISTS `reports` (
  `report_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` int(10) UNSIGNED NOT NULL,
  `node_id` int(10) UNSIGNED NOT NULL,
  `node_type` varchar(32) NOT NULL,
  `time` datetime NOT NULL,
  PRIMARY KEY (`report_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `static_pages`
--

DROP TABLE IF EXISTS `static_pages`;
CREATE TABLE IF NOT EXISTS `static_pages` (
  `page_id` int(10) NOT NULL AUTO_INCREMENT,
  `page_url` varchar(64) NOT NULL,
  `page_title` varchar(256) NOT NULL,
  `page_text` mediumtext NOT NULL,
  `page_in_footer` enum('0','1') NOT NULL DEFAULT '1',
  `page_order` int(10) NOT NULL DEFAULT '1',
  PRIMARY KEY (`page_id`),
  UNIQUE KEY `page_url` (`page_url`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `static_pages`
--

INSERT INTO `static_pages` (`page_id`, `page_url`, `page_title`, `page_text`, `page_in_footer`, `page_order`) VALUES
(1, 'about', 'About', '&lt;p&gt;Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.&lt;/p&gt;\r\n&lt;h3 class=&quot;text-info&quot;&gt;Big Title&lt;/h3&gt;\r\n&lt;p&gt;Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.&lt;/p&gt;\r\n&lt;h3 class=&quot;text-info&quot;&gt;Big Title&lt;/h3&gt;\r\n&lt;p&gt;Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.&lt;/p&gt;', '1', 1),
(2, 'terms', 'Terms', '&lt;p&gt;&lt;strong&gt; We run this website and permits its use according to the following terms and conditions: &lt;/strong&gt;&lt;/p&gt;\r\n&lt;h3 class=&quot;text-info&quot;&gt;Basic Terms:&lt;/h3&gt;\r\n&lt;ol&gt;\r\n&lt;li&gt;Using this website implies your acceptance of these conditions. If you do not fully accept them, your entry to this site will be considered unauthorized and you will have to stop using it immediately&lt;/li&gt;\r\n&lt;li&gt;You must be 13 years or older to use this site.&lt;/li&gt;\r\n&lt;li&gt;You are responsible for any activity that occurs under your screen name.&lt;/li&gt;\r\n&lt;li&gt;You are responsible for keeping your account secure.&lt;/li&gt;\r\n&lt;li&gt;You must not abuse, harass, threaten or intimidate other Sngine users.&lt;/li&gt;\r\n&lt;li&gt;You are solely responsible for your conduct and any data, text, information, screen names, graphics, photos, profiles, audio and video clips, links (&quot;Content&quot;) that you submit, post, and display on the Sngine service.&lt;/li&gt;\r\n&lt;li&gt;You must not modify, adapt or hack Sngine or modify another website so as to falsely imply that it is associated with Sngine&lt;/li&gt;\r\n&lt;li&gt;You must not create or submit unwanted email to any Sngine members (&quot;Spam&quot;).&lt;/li&gt;\r\n&lt;li&gt;You must not transmit any worms or viruses or any code of a destructive nature.&lt;/li&gt;\r\n&lt;li&gt;You must not, in the use of Sngine, violate any laws in your jurisdiction (including but not limited to copyright laws).&lt;/li&gt;\r\n&lt;/ol&gt;\r\n&lt;p&gt;Violation of any of these agreements will result in the termination of your Sngine account. While Sngine prohibits such conduct and content on its site, you understand and agree that Sngine cannot be responsible for the Content posted on its web site and you nonetheless may be exposed to such materials and that you use the Sngine service at your own risk.&lt;/p&gt;\r\n&lt;h3 class=&quot;text-info&quot;&gt;General Conditions:&lt;/h3&gt;\r\n&lt;ol&gt;\r\n&lt;li&gt;We reserve the right to modify or terminate the Sngine service for any reason, without notice at any time.&lt;/li&gt;\r\n&lt;li&gt;We reserve the right to alter these Terms of Use at any time. If the alterations constitute a material change to the Terms of Use, we will notify you via internet mail according to the preference expressed on your account. What constitutes a &quot;material change&quot; will be determined at our sole discretion, in good faith and using common sense and reasonable judgement.&lt;/li&gt;\r\n&lt;li&gt;We reserve the right to refuse service to anyone for any reason at any time.&lt;/li&gt;\r\n&lt;li&gt;We may, but have no obligation to, remove Content and accounts containing Content that we determine in our sole discretion are unlawful, offensive, threatening, libelous, defamatory, obscene or otherwise objectionable or violates any party&#039;s intellectual property or these Terms of Use.&lt;/li&gt;\r\n&lt;li&gt;Sngine service makes it possible to post images and text hosted on Sngine to outside websites. This use is accepted (and even encouraged!). However, pages on other websites which display data hosted on Sngine must provide a link back to Sngine.&lt;/li&gt;\r\n&lt;/ol&gt;\r\n&lt;h3 class=&quot;text-info&quot;&gt;Copyright (What&#039;s Yours is Yours):&lt;/h3&gt;\r\n&lt;ol&gt;\r\n&lt;li&gt;We claim no intellectual property rights over the material you provide to the Sngine service. Your profile and materials uploaded remain yours. You can remove your profile at any time by deleting your account. This will also remove any text and images you have stored in the system.&lt;/li&gt;\r\n&lt;li&gt;We encourage users to contribute their creations to the public domain or consider progressive licensing terms.&lt;/li&gt;\r\n&lt;/ol&gt;\r\n&lt;p&gt;&lt;small&gt; &lt;em&gt;Last updated on: Jan 29, 2016&lt;/em&gt; &lt;/small&gt;&lt;/p&gt;', '1', 2),
(3, 'privacy', 'Privacy', '&lt;p&gt;We recognize that your privacy is very important and take it seriously. This Privacy Policy describes Sngine&#039;s policies and procedures on the collection, use and disclosure of your information when you use the Sngine Service. We will not use or share your information with anyone except as described in this Privacy Policy.&lt;/p&gt;\r\n&lt;h3 class=&quot;text-info&quot;&gt;Information Collection and Use&lt;/h3&gt;\r\n&lt;p&gt;We uses information we collect to analyze how the Service is used, diagnose service or technical problems, maintain security, personalize content, remember information to help you efficiently access your account, monitor aggregate metrics such as total number of visitors, traffic, and demographic patterns, and track User Content and users as necessary to comply with the Digital Millennium Copyright Act and other applicable laws.&lt;/p&gt;\r\n&lt;h4 class=&quot;text-danger&quot;&gt;User-Provided Information:&lt;/h4&gt;\r\n&lt;p&gt;You provide us information about yourself, such as your name and e-mail address, if you register for a member account with the Service. Your name and other information you choose to add to your profile will be available for public viewing on the Service. We may use your email address to send you Service-related notices. You can control receipt of certain Service-related messages on your Settings page. We may also use your contact information to send you marketing messages. If you do not want to receive such messages, you may opt out by following the instructions in the message. If you correspond with us by email, we may retain the content of your email messages, your email address and our responses.&lt;/p&gt;\r\n&lt;p&gt;You also provide us information in User Content you post to the Service. Your posts and other contributions on the Service, and metadata about them (such as when you posted them), are publicly viewable on the Service, along with your name (unless the Service permits you to post anonymously). This information may be searched by search engines and be republished elsewhere on the Web in accordance with our Terms of Service.&lt;/p&gt;\r\n&lt;p&gt;If you choose to use our invitation service to invite a friend to the Service, we will ask you for that person&#039;s email address and automatically send an email invitation. We stores this information to send this email, to register your friend if your invitation is accepted, and to track the success of our invitation service.&lt;/p&gt;\r\n&lt;h4 class=&quot;text-danger&quot;&gt;Cookies:&lt;/h4&gt;\r\n&lt;p&gt;When you visit the Service, we may send one or more &quot;cookies&quot; - small data files - to your computer to uniquely identify your browser and let Sngine help you log in faster and enhance your navigation through the site. A cookie may convey anonymous information about how you browse the Service to us, but does not collect personal information about you. A persistent cookie remains on your computer after you close your browser so that it can be used by your browser on subsequent visits to the Service. Persistent cookies can be removed by following your web browser&#039;s directions. A session cookie is temporary and disappears after you close your browser. You can reset your web browser to refuse all cookies or to indicate when a cookie is being sent. However, some features of the Service may not function properly if the ability to accept cookies is disabled.&lt;/p&gt;\r\n&lt;h4 class=&quot;text-danger&quot;&gt;Log Files:&lt;/h4&gt;\r\n&lt;p&gt;Log file information is automatically reported by your browser each time you access a web page. When you use the Service, our servers automatically record certain information that your web browser sends whenever you visit any website. These server logs may include information such as your web request, Internet Protocol (&quot;IP&quot;) address, browser type, referring / exit pages and URLs, number of clicks, domain names, landing pages, pages viewed, and other such information.&lt;/p&gt;\r\n&lt;h4 class=&quot;text-danger&quot;&gt;Third Party Services:&lt;/h4&gt;\r\n&lt;p&gt;We may use Google Analytics or Mixpanel to help understand use of the Service. Google Analytics and Mixpanel collect the information sent by your browser as part of a web page request, including cookies and your IP address. Google Analytics and Mixpanel also receive this information and their use of it is governed by their Privacy Policies.&lt;/p&gt;\r\n&lt;h3 class=&quot;text-info&quot;&gt;How We Share Your Information&lt;/h3&gt;\r\n&lt;h4 class=&quot;text-danger&quot;&gt;Personally Identifiable Information:&lt;/h4&gt;\r\n&lt;p&gt;We may share your personally identifiable information with third parties for the purpose of providing the Service to you. If we do this, such third parties&#039; use of your information will be bound by this Privacy Policy. We may store personal information in locations outside the direct control of Sngine (for instance, on servers or databases co-located with hosting providers).&lt;/p&gt;\r\n&lt;p&gt;We may share or disclose your information with your consent, such as if you choose to sign on to the Service through a third-party service. We cannot control third parties&#039; use of your information.&lt;/p&gt;\r\n&lt;p&gt;Sngine may disclose your personal information if required to do so by law or subpoena or if we believe that it is reasonably necessary to comply with a law, regulation or legal request; to protect the safety of any person; to address fraud, security or technical issues; or to protect Sngine&#039;s rights or property.&lt;/p&gt;\r\n&lt;h4 class=&quot;text-danger&quot;&gt;Non-Personally Identifiable Information:&lt;/h4&gt;\r\n&lt;p&gt;We may share non-personally identifiable information (such as anonymous usage data, referring/exit pages and URLs, platform types, number of clicks, etc.) with interested third parties to help them understand the usage patterns for certain Sngine services.&lt;/p&gt;\r\n&lt;p&gt;Sngine may allow third-party ad servers or ad networks to serve advertisements on the Service. These third-party ad servers or ad networks use technology to send, directly to your browser, the advertisements and links that appear on Sngine. They automatically receive your IP address when this happens. They may also use other technologies (such as cookies, JavaScript, or web beacons) to measure the effectiveness of their advertisements and to personalize the advertising content. Sngine does not provide any personally identifiable information to these third-party ad servers or ad networks without your consent. However, please note that if an advertiser asks Sngine to show an advertisement to a certain audience and you respond to that advertisement, the advertiser or ad server may conclude that you fit the description of the audience they are trying to reach. The Sngine Privacy Policy does not apply to, and we cannot control the activities of, third-party advertisers. Please consult the respective privacy policies of such advertisers for more information.&lt;/p&gt;\r\n&lt;h3 class=&quot;text-info&quot;&gt;How We Protect Your Information&lt;/h3&gt;\r\n&lt;p&gt;We uses commercially reasonable physical, managerial, and technical safeguards to preserve the integrity and security of your personal information. We cannot, however, ensure or warrant the security of any information you transmit to Sngine or guarantee that your information on the Service may not be accessed, disclosed, altered, or destroyed by breach of any of our physical, technical, or managerial safeguards.&lt;/p&gt;\r\n&lt;h3 class=&quot;text-info&quot;&gt;Your Choices About Your Information&lt;/h3&gt;\r\n&lt;p&gt;You may, of course, decline to submit personally identifiable information through the Service, in which case Sngine may not be able to provide certain services to you. You may update or correct your account information and email preferences at any time by logging in to your account.&lt;/p&gt;\r\n&lt;h3 class=&quot;text-info&quot;&gt;Links to Other Web Sites&lt;/h3&gt;\r\n&lt;p&gt;We are not responsible for the practices employed by websites linked to or from the Service, nor the information or content contained therein. Please remember that when you use a link to go from the Service to another website, our Privacy Policy is no longer in effect. Your browsing and interaction on any other website, including those that have a link on our website, is subject to that website&#039;s own rules and policies.&lt;/p&gt;\r\n&lt;h3 class=&quot;text-info&quot;&gt;Changes to Our Privacy Policy&lt;/h3&gt;\r\n&lt;p&gt;If we change our privacy policies and procedures, we will post those changes on this page to keep you aware of what information we collect, how we use it and under what circumstances we may disclose it. Changes to this Privacy Policy are effective when they are posted on this page.&lt;/p&gt;\r\n&lt;h4 class=&quot;text-danger&quot;&gt;&lt;small&gt; &lt;em&gt;Last updated on: Jan 29, 2016&lt;/em&gt; &lt;/small&gt;&lt;/h4&gt;', '1', 3);

-- --------------------------------------------------------

--
-- Table structure for table `stickers`
--

DROP TABLE IF EXISTS `stickers`;
CREATE TABLE IF NOT EXISTS `stickers` (
  `sticker_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `image` varchar(256) NOT NULL,
  PRIMARY KEY (`sticker_id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `stickers`
--

INSERT INTO `stickers` (`sticker_id`, `image`) VALUES
(1, 'stickers/1.png'),
(2, 'stickers/2.png'),
(3, 'stickers/3.png'),
(4, 'stickers/4.png'),
(5, 'stickers/5.png'),
(6, 'stickers/6.png'),
(7, 'stickers/7.png'),
(8, 'stickers/8.png'),
(9, 'stickers/9.png'),
(10, 'stickers/10.png'),
(11, 'stickers/11.png'),
(12, 'stickers/12.png'),
(13, 'stickers/13.png'),
(14, 'stickers/14.png'),
(15, 'stickers/15.png'),
(16, 'stickers/16.png'),
(17, 'stickers/17.png'),
(18, 'stickers/18.png'),
(19, 'stickers/19.png'),
(20, 'stickers/20.png');

-- --------------------------------------------------------

--
-- Table structure for table `stories`
--

DROP TABLE IF EXISTS `stories`;
CREATE TABLE IF NOT EXISTS `stories` (
  `story_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` int(10) UNSIGNED NOT NULL,
  `time` datetime NOT NULL,
  PRIMARY KEY (`story_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `stories_media`
--

DROP TABLE IF EXISTS `stories_media`;
CREATE TABLE IF NOT EXISTS `stories_media` (
  `media_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `story_id` int(10) UNSIGNED NOT NULL,
  `source` varchar(256) NOT NULL,
  `is_photo` enum('0','1') NOT NULL DEFAULT '1',
  `text` text NOT NULL,
  `time` datetime NOT NULL,
  PRIMARY KEY (`media_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `system_countries`
--

DROP TABLE IF EXISTS `system_countries`;
CREATE TABLE IF NOT EXISTS `system_countries` (
  `country_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `country_code` varchar(2) NOT NULL,
  `country_name` varchar(64) NOT NULL,
  PRIMARY KEY (`country_id`)
) ENGINE=InnoDB AUTO_INCREMENT=246 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `system_countries`
--

INSERT INTO `system_countries` (`country_id`, `country_code`, `country_name`) VALUES
(1, 'AF', 'Afghanistan'),
(2, 'AL', 'Albania'),
(3, 'DZ', 'Algeria'),
(4, 'DS', 'American Samoa'),
(5, 'AD', 'Andorra'),
(6, 'AO', 'Angola'),
(7, 'AI', 'Anguilla'),
(8, 'AQ', 'Antarctica'),
(9, 'AG', 'Antigua and Barbuda'),
(10, 'AR', 'Argentina'),
(11, 'AM', 'Armenia'),
(12, 'AW', 'Aruba'),
(13, 'AU', 'Australia'),
(14, 'AT', 'Austria'),
(15, 'AZ', 'Azerbaijan'),
(16, 'BS', 'Bahamas'),
(17, 'BH', 'Bahrain'),
(18, 'BD', 'Bangladesh'),
(19, 'BB', 'Barbados'),
(20, 'BY', 'Belarus'),
(21, 'BE', 'Belgium'),
(22, 'BZ', 'Belize'),
(23, 'BJ', 'Benin'),
(24, 'BM', 'Bermuda'),
(25, 'BT', 'Bhutan'),
(26, 'BO', 'Bolivia'),
(27, 'BA', 'Bosnia and Herzegovina'),
(28, 'BW', 'Botswana'),
(29, 'BV', 'Bouvet Island'),
(30, 'BR', 'Brazil'),
(31, 'IO', 'British Indian Ocean Territory'),
(32, 'BN', 'Brunei Darussalam'),
(33, 'BG', 'Bulgaria'),
(34, 'BF', 'Burkina Faso'),
(35, 'BI', 'Burundi'),
(36, 'KH', 'Cambodia'),
(37, 'CM', 'Cameroon'),
(38, 'CA', 'Canada'),
(39, 'CV', 'Cape Verde'),
(40, 'KY', 'Cayman Islands'),
(41, 'CF', 'Central African Republic'),
(42, 'TD', 'Chad'),
(43, 'CL', 'Chile'),
(44, 'CN', 'China'),
(45, 'CX', 'Christmas Island'),
(46, 'CC', 'Cocos (Keeling) Islands'),
(47, 'CO', 'Colombia'),
(48, 'KM', 'Comoros'),
(49, 'CG', 'Congo'),
(50, 'CK', 'Cook Islands'),
(51, 'CR', 'Costa Rica'),
(52, 'HR', 'Croatia (Hrvatska)'),
(53, 'CU', 'Cuba'),
(54, 'CY', 'Cyprus'),
(55, 'CZ', 'Czech Republic'),
(56, 'DK', 'Denmark'),
(57, 'DJ', 'Djibouti'),
(58, 'DM', 'Dominica'),
(59, 'DO', 'Dominican Republic'),
(60, 'TP', 'East Timor'),
(61, 'EC', 'Ecuador'),
(62, 'EG', 'Egypt'),
(63, 'SV', 'El Salvador'),
(64, 'GQ', 'Equatorial Guinea'),
(65, 'ER', 'Eritrea'),
(66, 'EE', 'Estonia'),
(67, 'ET', 'Ethiopia'),
(68, 'FK', 'Falkland Islands (Malvinas)'),
(69, 'FO', 'Faroe Islands'),
(70, 'FJ', 'Fiji'),
(71, 'FI', 'Finland'),
(72, 'FR', 'France'),
(73, 'FX', 'France, Metropolitan'),
(74, 'GF', 'French Guiana'),
(75, 'PF', 'French Polynesia'),
(76, 'TF', 'French Southern Territories'),
(77, 'GA', 'Gabon'),
(78, 'GM', 'Gambia'),
(79, 'GE', 'Georgia'),
(80, 'DE', 'Germany'),
(81, 'GH', 'Ghana'),
(82, 'GI', 'Gibraltar'),
(83, 'GK', 'Guernsey'),
(84, 'GR', 'Greece'),
(85, 'GL', 'Greenland'),
(86, 'GD', 'Grenada'),
(87, 'GP', 'Guadeloupe'),
(88, 'GU', 'Guam'),
(89, 'GT', 'Guatemala'),
(90, 'GN', 'Guinea'),
(91, 'GW', 'Guinea-Bissau'),
(92, 'GY', 'Guyana'),
(93, 'HT', 'Haiti'),
(94, 'HM', 'Heard and Mc Donald Islands'),
(95, 'HN', 'Honduras'),
(96, 'HK', 'Hong Kong'),
(97, 'HU', 'Hungary'),
(98, 'IS', 'Iceland'),
(99, 'IN', 'India'),
(100, 'IM', 'Isle of Man'),
(101, 'ID', 'Indonesia'),
(102, 'IR', 'Iran (Islamic Republic of)'),
(103, 'IQ', 'Iraq'),
(104, 'IE', 'Ireland'),
(105, 'IL', 'Israel'),
(106, 'IT', 'Italy'),
(107, 'CI', 'Ivory Coast'),
(108, 'JE', 'Jersey'),
(109, 'JM', 'Jamaica'),
(110, 'JP', 'Japan'),
(111, 'JO', 'Jordan'),
(112, 'KZ', 'Kazakhstan'),
(113, 'KE', 'Kenya'),
(114, 'KI', 'Kiribati'),
(115, 'KP', 'Korea, Democratic People\'s Republic of'),
(116, 'KR', 'Korea, Republic of'),
(117, 'XK', 'Kosovo'),
(118, 'KW', 'Kuwait'),
(119, 'KG', 'Kyrgyzstan'),
(120, 'LA', 'Lao People\'s Democratic Republic'),
(121, 'LV', 'Latvia'),
(122, 'LB', 'Lebanon'),
(123, 'LS', 'Lesotho'),
(124, 'LR', 'Liberia'),
(125, 'LY', 'Libyan Arab Jamahiriya'),
(126, 'LI', 'Liechtenstein'),
(127, 'LT', 'Lithuania'),
(128, 'LU', 'Luxembourg'),
(129, 'MO', 'Macau'),
(130, 'MK', 'Macedonia'),
(131, 'MG', 'Madagascar'),
(132, 'MW', 'Malawi'),
(133, 'MY', 'Malaysia'),
(134, 'MV', 'Maldives'),
(135, 'ML', 'Mali'),
(136, 'MT', 'Malta'),
(137, 'MH', 'Marshall Islands'),
(138, 'MQ', 'Martinique'),
(139, 'MR', 'Mauritania'),
(140, 'MU', 'Mauritius'),
(141, 'TY', 'Mayotte'),
(142, 'MX', 'Mexico'),
(143, 'FM', 'Micronesia, Federated States of'),
(144, 'MD', 'Moldova, Republic of'),
(145, 'MC', 'Monaco'),
(146, 'MN', 'Mongolia'),
(147, 'ME', 'Montenegro'),
(148, 'MS', 'Montserrat'),
(149, 'MA', 'Morocco'),
(150, 'MZ', 'Mozambique'),
(151, 'MM', 'Myanmar'),
(152, 'NA', 'Namibia'),
(153, 'NR', 'Nauru'),
(154, 'NP', 'Nepal'),
(155, 'NL', 'Netherlands'),
(156, 'AN', 'Netherlands Antilles'),
(157, 'NC', 'New Caledonia'),
(158, 'NZ', 'New Zealand'),
(159, 'NI', 'Nicaragua'),
(160, 'NE', 'Niger'),
(161, 'NG', 'Nigeria'),
(162, 'NU', 'Niue'),
(163, 'NF', 'Norfolk Island'),
(164, 'MP', 'Northern Mariana Islands'),
(165, 'NO', 'Norway'),
(166, 'OM', 'Oman'),
(167, 'PK', 'Pakistan'),
(168, 'PW', 'Palau'),
(169, 'PS', 'Palestine'),
(170, 'PA', 'Panama'),
(171, 'PG', 'Papua New Guinea'),
(172, 'PY', 'Paraguay'),
(173, 'PE', 'Peru'),
(174, 'PH', 'Philippines'),
(175, 'PN', 'Pitcairn'),
(176, 'PL', 'Poland'),
(177, 'PT', 'Portugal'),
(178, 'PR', 'Puerto Rico'),
(179, 'QA', 'Qatar'),
(180, 'RE', 'Reunion'),
(181, 'RO', 'Romania'),
(182, 'RU', 'Russian Federation'),
(183, 'RW', 'Rwanda'),
(184, 'KN', 'Saint Kitts and Nevis'),
(185, 'LC', 'Saint Lucia'),
(186, 'VC', 'Saint Vincent and the Grenadines'),
(187, 'WS', 'Samoa'),
(188, 'SM', 'San Marino'),
(189, 'ST', 'Sao Tome and Principe'),
(190, 'SA', 'Saudi Arabia'),
(191, 'SN', 'Senegal'),
(192, 'RS', 'Serbia'),
(193, 'SC', 'Seychelles'),
(194, 'SL', 'Sierra Leone'),
(195, 'SG', 'Singapore'),
(196, 'SK', 'Slovakia'),
(197, 'SI', 'Slovenia'),
(198, 'SB', 'Solomon Islands'),
(199, 'SO', 'Somalia'),
(200, 'ZA', 'South Africa'),
(201, 'GS', 'South Georgia South Sandwich Islands'),
(202, 'ES', 'Spain'),
(203, 'LK', 'Sri Lanka'),
(204, 'SH', 'St. Helena'),
(205, 'PM', 'St. Pierre and Miquelon'),
(206, 'SD', 'Sudan'),
(207, 'SR', 'Suriname'),
(208, 'SJ', 'Svalbard and Jan Mayen Islands'),
(209, 'SZ', 'Swaziland'),
(210, 'SE', 'Sweden'),
(211, 'CH', 'Switzerland'),
(212, 'SY', 'Syrian Arab Republic'),
(213, 'TW', 'Taiwan'),
(214, 'TJ', 'Tajikistan'),
(215, 'TZ', 'Tanzania, United Republic of'),
(216, 'TH', 'Thailand'),
(217, 'TG', 'Togo'),
(218, 'TK', 'Tokelau'),
(219, 'TO', 'Tonga'),
(220, 'TT', 'Trinidad and Tobago'),
(221, 'TN', 'Tunisia'),
(222, 'TR', 'Turkey'),
(223, 'TM', 'Turkmenistan'),
(224, 'TC', 'Turks and Caicos Islands'),
(225, 'TV', 'Tuvalu'),
(226, 'UG', 'Uganda'),
(227, 'UA', 'Ukraine'),
(228, 'AE', 'United Arab Emirates'),
(229, 'GB', 'United Kingdom'),
(230, 'US', 'United States'),
(231, 'UM', 'United States minor outlying islands'),
(232, 'UY', 'Uruguay'),
(233, 'UZ', 'Uzbekistan'),
(234, 'VU', 'Vanuatu'),
(235, 'VA', 'Vatican City State'),
(236, 'VE', 'Venezuela'),
(237, 'VN', 'Vietnam'),
(238, 'VG', 'Virgin Islands (British)'),
(239, 'VI', 'Virgin Islands (U.S.)'),
(240, 'WF', 'Wallis and Futuna Islands'),
(241, 'EH', 'Western Sahara'),
(242, 'YE', 'Yemen'),
(243, 'ZR', 'Zaire'),
(244, 'ZM', 'Zambia'),
(245, 'ZW', 'Zimbabwe');

-- --------------------------------------------------------

--
-- Table structure for table `system_currencies`
--

DROP TABLE IF EXISTS `system_currencies`;
CREATE TABLE IF NOT EXISTS `system_currencies` (
  `currency_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(256) NOT NULL,
  `code` varchar(32) NOT NULL,
  `symbol` varchar(32) NOT NULL,
  `default` enum('0','1') NOT NULL,
  PRIMARY KEY (`currency_id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `system_currencies`
--

INSERT INTO `system_currencies` (`currency_id`, `name`, `code`, `symbol`, `default`) VALUES
(1, 'Australia Dollar', 'AUD', '$', '0'),
(2, 'Brazil Real', 'BRL', 'R$', '0'),
(3, 'Canada Dollar', 'CAD', '$', '0'),
(4, 'Czech Republic Koruna', 'CZK', 'KÄ', '0'),
(5, 'Denmark Krone', 'DKK', 'kr', '0'),
(6, 'Euro', 'EUR', '&euro;', '0'),
(7, 'Hong Kong Dollar', 'HKD', '$', '0'),
(8, 'Hungary Forint', 'HUF', 'Ft', '0'),
(9, 'Israel Shekel', 'ILS', 'â‚ª', '0'),
(10, 'Japan Yen', 'JPY', '&yen;', '0'),
(11, 'Malaysia Ringgit', 'MYR', 'RM', '0'),
(12, 'Mexico Peso', 'MXN', '$', '0'),
(13, 'Norway Krone', 'NOK', 'kr', '0'),
(14, 'New Zealand Dollar', 'NZD', '$', '0'),
(15, 'Philippines Peso', 'PHP', 'â‚±', '0'),
(16, 'Poland Zloty', 'PLN', 'zÅ‚', '0'),
(17, 'United Kingdom Pound', 'GBP', '&pound;', '0'),
(18, 'Russia Ruble', 'RUB', 'â‚½', '0'),
(19, 'Singapore Dollar', 'SGD', '$', '0'),
(20, 'Sweden Krona', 'SEK', 'kr', '0'),
(21, 'Switzerland Franc', 'CHF', 'CHF', '0'),
(22, 'Thailand Baht', 'THB', 'à¸¿', '0'),
(23, 'Turkey Lira', 'TRY', 'TRY', '0'),
(24, 'United States Dollar', 'USD', '$', '1');

-- --------------------------------------------------------

--
-- Table structure for table `system_genders`
--

DROP TABLE IF EXISTS `system_genders`;
CREATE TABLE IF NOT EXISTS `system_genders` (
  `gender_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `gender_name` varchar(64) NOT NULL,
  `gender_order` int(10) NOT NULL DEFAULT '1',
  PRIMARY KEY (`gender_id`) USING BTREE,
  UNIQUE KEY `name` (`gender_name`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `system_genders`
--

INSERT INTO `system_genders` (`gender_id`, `gender_name`, `gender_order`) VALUES
(1, 'Male', 1),
(2, 'Female', 2),
(3, 'Other', 3);

-- --------------------------------------------------------

--
-- Table structure for table `system_languages`
--

DROP TABLE IF EXISTS `system_languages`;
CREATE TABLE IF NOT EXISTS `system_languages` (
  `language_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `code` varchar(32) NOT NULL,
  `title` varchar(256) NOT NULL,
  `flag` varchar(256) NOT NULL,
  `dir` enum('LTR','RTL') NOT NULL,
  `default` enum('0','1') NOT NULL,
  `enabled` enum('0','1') NOT NULL,
  PRIMARY KEY (`language_id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `system_languages`
--

INSERT INTO `system_languages` (`language_id`, `code`, `title`, `flag`, `dir`, `default`, `enabled`) VALUES
(1, 'en_us', 'English', 'flags/en_us.png', 'LTR', '1', '1'),
(2, 'ar_sa', 'Arabic', 'flags/ar_sa.png', 'RTL', '0', '1'),
(3, 'fr_fr', 'French', 'flags/fr_fr.png', 'LTR', '0', '1'),
(4, 'es_es', 'Spanish', 'flags/es_es.png', 'LTR', '0', '1'),
(5, 'pt_pt', 'Portuguese', 'flags/pt_pt.png', 'LTR', '0', '1'),
(6, 'de_de', 'Deutsch', 'flags/de_de.png', 'LTR', '0', '1'),
(7, 'tr_tr', 'Turkish', 'flags/tr_tr.png', 'LTR', '0', '1'),
(8, 'nl_nl', 'Dutch', 'flags/nl_nl.png', 'LTR', '0', '1'),
(9, 'it_it', 'Italiano', 'flags/it_it.png', 'LTR', '0', '1'),
(10, 'ru_ru', 'Russian', 'flags/ru_ru.png', 'LTR', '0', '1'),
(11, 'ro_ro', 'Romaian', 'flags/ro_ro.png', 'LTR', '0', '1'),
(12, 'pt_br', 'Portuguese (Brazil)', 'flags/pt_br.png', 'LTR', '0', '1'),
(13, 'el_gr', 'Greek', 'flags/el_gr.png', 'LTR', '0', '1');

-- --------------------------------------------------------

--
-- Table structure for table `system_options`
--

DROP TABLE IF EXISTS `system_options`;
CREATE TABLE IF NOT EXISTS `system_options` (
  `option_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `option_name` varchar(128) NOT NULL,
  `option_value` varchar(2048) DEFAULT NULL,
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=InnoDB AUTO_INCREMENT=697 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `system_options`
--

INSERT INTO `system_options` (`option_id`, `option_name`, `option_value`) VALUES
(1, 'system_public', '1'),
(2, 'system_live', '1'),
(3, 'system_message', 'We will Back Soon'),
(4, 'system_title', 'Sngine'),
(5, 'system_description', 'Share your memories, connect with others, make new friends'),
(6, 'system_keywords', ''),
(7, 'system_email', ''),
(8, 'system_datetime_format', 'd/m/Y H:i'),
(9, 'contact_enabled', '1'),
(10, 'directory_enabled', '1'),
(11, 'pages_enabled', '1'),
(12, 'groups_enabled', '1'),
(13, 'events_enabled', '1'),
(14, 'blogs_enabled', '1'),
(15, 'users_blogs_enabled', '1'),
(16, 'market_enabled', '1'),
(17, 'movies_enabled', '0'),
(18, 'games_enabled', '0'),
(19, 'daytime_msg_enabled', '1'),
(20, 'pokes_enabled', '1'),
(21, 'gifts_enabled', '0'),
(22, 'profile_notification_enabled', '1'),
(23, 'browser_notifications_enabled', '1'),
(24, 'noty_notifications_enabled', '1'),
(25, 'cookie_consent_enabled', '1'),
(26, 'adblock_detector_enabled', '1'),
(27, 'stories_enabled', '1'),
(28, 'popular_posts_enabled', '1'),
(29, 'discover_posts_enabled', '1'),
(30, 'memories_enabled', '1'),
(31, 'wall_posts_enabled', '1'),
(32, 'activity_posts_enabled', '1'),
(33, 'colored_posts_enabled', '1'),
(34, 'polls_enabled', '1'),
(35, 'geolocation_enabled', '0'),
(36, 'geolocation_key', ''),
(37, 'gif_enabled', '0'),
(38, 'giphy_key', ''),
(39, 'post_translation_enabled', '0'),
(40, 'yandex_key', ''),
(41, 'smart_yt_player', '1'),
(42, 'social_share_enabled', '1'),
(43, 'max_post_length', '5000'),
(44, 'max_comment_length', '5000'),
(45, 'max_posts_hour', '0'),
(46, 'max_comments_hour', '0'),
(47, 'default_privacy', 'public'),
(48, 'trending_hashtags_enabled', '1'),
(49, 'trending_hashtags_interval', 'week'),
(50, 'trending_hashtags_limit', '5'),
(51, 'registration_enabled', '1'),
(52, 'registration_type', 'free'),
(53, 'invitation_enabled', '0'),
(56, 'packages_enabled', '0'),
(57, 'packages_wallet_payment_enabled', '0'),
(58, 'activation_enabled', '0'),
(59, 'activation_type', 'email'),
(60, 'verification_requests', '1'),
(61, 'age_restriction', '0'),
(62, 'minimum_age', '13'),
(63, 'getting_started', '1'),
(64, 'delete_accounts_enabled', '1'),
(65, 'download_info_enabled', '1'),
(66, 'newsletter_consent', '1'),
(67, 'max_accounts', '0'),
(68, 'max_friends', '5000'),
(69, 'social_login_enabled', '0'),
(70, 'facebook_login_enabled', '0'),
(71, 'facebook_appid', ''),
(72, 'facebook_secret', ''),
(73, 'google_login_enabled', '0'),
(74, 'google_appid', ''),
(75, 'google_secret', ''),
(76, 'twitter_login_enabled', '0'),
(77, 'twitter_appid', ''),
(78, 'twitter_secret', ''),
(82, 'linkedin_login_enabled', '0'),
(83, 'linkedin_appid', ''),
(84, 'linkedin_secret', ''),
(85, 'vkontakte_login_enabled', '0'),
(86, 'vkontakte_appid', ''),
(87, 'vkontakte_secret', ''),
(88, 'email_smtp_enabled', '0'),
(89, 'email_smtp_authentication', '0'),
(90, 'email_smtp_ssl', '0'),
(91, 'email_smtp_server', ''),
(92, 'email_smtp_port', ''),
(93, 'email_smtp_username', ''),
(94, 'email_smtp_password', ''),
(95, 'email_smtp_setfrom', ''),
(96, 'email_notifications', '0'),
(97, 'email_post_likes', '0'),
(98, 'email_post_comments', '0'),
(99, 'email_post_shares', '0'),
(100, 'email_wall_posts', '0'),
(101, 'email_mentions', '0'),
(102, 'email_profile_visits', '0'),
(103, 'email_friend_requests', '0'),
(104, 'twilio_sid', ''),
(105, 'twilio_token', ''),
(106, 'twilio_phone', ''),
(107, 'twilio_apisid', ''),
(108, 'twilio_apisecret', ''),
(109, 'system_phone', ''),
(110, 'chat_enabled', '1'),
(111, 'chat_status_enabled', '1'),
(112, 'chat_typing_enabled', '1'),
(113, 'chat_seen_enabled', '1'),
(114, 'video_call_enabled', '0'),
(115, 'audio_call_enabled', '0'),
(116, 'uploads_directory', 'content/uploads'),
(117, 'uploads_prefix', 'sngine'),
(118, 'max_avatar_size', '5120'),
(119, 'max_cover_size', '5120'),
(120, 'photos_enabled', '1'),
(121, 'max_photo_size', '5120'),
(122, 'uploads_quality', 'medium'),
(123, 'videos_enabled', '1'),
(124, 'max_video_size', '5120'),
(125, 'video_extensions', 'mp4, webm, ogg'),
(126, 'audio_enabled', '1'),
(127, 'max_audio_size', '5120'),
(128, 'audio_extensions', 'mp3, wav, ogg'),
(129, 'file_enabled', '1'),
(130, 'max_file_size', '5120'),
(131, 'file_extensions', 'txt, zip'),
(132, 's3_enabled', '0'),
(133, 's3_bucket', ''),
(134, 's3_region', 'us-east-2'),
(135, 's3_key', ''),
(136, 's3_secret', ''),
(137, 'digitalocean_enabled', '0'),
(138, 'digitalocean_space_name', ''),
(139, 'digitalocean_space_region', 'sfo2'),
(140, 'digitalocean_key', ''),
(141, 'digitalocean_secret', ''),
(142, 'ftp_enabled', '0'),
(143, 'ftp_hostname', ''),
(144, 'ftp_port', ''),
(145, 'ftp_username', ''),
(146, 'ftp_password', ''),
(147, 'ftp_path', ''),
(148, 'ftp_endpoint', ''),
(149, 'session_hash', '2dZ1m8QTG-3vwmk-4dDxB-49wkl-36eKM-9767c0066ae4'),
(150, 'unusual_login_enabled', '0'),
(151, 'brute_force_detection_enabled', '1'),
(152, 'brute_force_bad_login_limit', '5'),
(153, 'brute_force_lockout_time', '10'),
(154, 'two_factor_enabled', '1'),
(155, 'two_factor_type', 'google'),
(156, 'censored_words_enabled', '1'),
(157, 'censored_words', 'pussy,fuck,shit,asshole,dick,tits,boobs'),
(158, 'reCAPTCHA_enabled', '0'),
(159, 'reCAPTCHA_site_key', ''),
(160, 'reCAPTCHA_secret_key', ''),
(161, 'paypal_enabled', '0'),
(162, 'paypal_mode', 'sandbox'),
(163, 'paypal_id', ''),
(164, 'paypal_secret', ''),
(165, 'creditcard_enabled', '0'),
(166, 'alipay_enabled', '0'),
(167, 'stripe_mode', 'test'),
(168, 'stripe_test_secret', ''),
(169, 'stripe_test_publishable', ''),
(170, 'stripe_live_secret', ''),
(171, 'stripe_live_publishable', ''),
(172, 'coinpayments_enabled', '0'),
(173, 'coinpayments_merchant_id', ''),
(174, 'coinpayments_ipn_secret', ''),
(175, '2checkout_enabled', '0'),
(176, '2checkout_mode', 'sandbox'),
(177, '2checkout_merchant_code', ''),
(178, '2checkout_publishable_key', ''),
(179, '2checkout_private_key', ''),
(180, 'bank_transfers_enabled', '0'),
(181, 'bank_name', ''),
(182, 'bank_account_number', ''),
(183, 'bank_account_name', ''),
(184, 'bank_account_routing', ''),
(185, 'bank_account_country', ''),
(186, 'bank_transfer_note', 'In order to confirm the bank transfer, you will need to upload a receipt or take a screenshot of your transfer within 1 day from your payment date. If a bank transfer is made but no receipt is uploaded within this period, your order will be cancelled. We will verify and confirm your receipt within 3 working days from the date you upload it.'),
(187, 'data_heartbeat', '5'),
(188, 'chat_heartbeat', '5'),
(189, 'offline_time', '10'),
(190, 'min_results', '5'),
(191, 'max_results', '10'),
(192, 'min_results_even', '6'),
(193, 'max_results_even', '12'),
(194, 'analytics_code', ''),
(195, 'system_theme_night_on', '0'),
(196, 'system_theme_mode_select', '1'),
(197, 'system_profile_background_enabled', '1'),
(198, 'system_logo', ''),
(199, 'system_wallpaper_default', '1'),
(200, 'system_wallpaper', ''),
(201, 'system_favicon_default', '1'),
(202, 'system_favicon', ''),
(203, 'system_ogimage_default', '1'),
(204, 'system_ogimage', ''),
(205, 'css_customized', '0'),
(206, 'css_background', ''),
(207, 'css_link_color', ''),
(208, 'css_header', ''),
(209, 'css_header_search', ''),
(210, 'css_header_search_color', ''),
(211, 'css_btn_primary', ''),
(212, 'css_custome_css', '/* \r\n\r\nAdd here your custom css styles \r\nExample:\r\np { text-align: center; color: red; }\r\n\r\n*/'),
(213, 'custome_js_header', '/* \r\nYou can add your JavaScript code here\r\n\r\nExample:\r\n\r\nvar x, y, z;\r\nx = 1;\r\ny = 2;\r\nz = x + y;\r\n*/'),
(214, 'custome_js_footer', '/* \r\nYou can add your JavaScript code here\r\n\r\nExample:\r\n\r\nvar x, y, z;\r\nx = 1;\r\ny = 2;\r\nz = x + y;\r\n*/'),
(215, 'forums_enabled', '0'),
(216, 'forums_online_enabled', '1'),
(217, 'forums_statistics_enabled', '1'),
(218, 'affiliates_enabled', '0'),
(219, 'affiliate_type', 'registration'),
(220, 'affiliate_payment_method', 'paypal,skrill'),
(221, 'affiliate_payment_method_custom', ''),
(222, 'affiliates_min_withdrawal', '50'),
(223, 'affiliate_payment_type', 'fixed'),
(224, 'affiliates_per_user', '0.10'),
(225, 'affiliates_percentage', '1'),
(226, 'points_enabled', '0'),
(227, 'points_money_withdraw_enabled', '1'),
(228, 'points_payment_method', 'paypal,skrill'),
(229, 'points_payment_method_custom', ''),
(230, 'points_min_withdrawal', '50'),
(231, 'points_money_transfer_enabled', '0'),
(232, 'points_per_currency', '100'),
(233, 'points_per_post', '20'),
(234, 'points_per_comment', '10'),
(235, 'points_per_reaction', '5'),
(236, 'points_limit_user', '1000'),
(237, 'points_limit_pro', '2000'),
(238, 'ads_enabled', '0'),
(239, 'ads_cost_click', '0.05'),
(240, 'ads_cost_view', '0.01'),
(241, 'developers_apps_enabled', '0'),
(242, 'developers_share_enabled', '0'),
(243, 'auto_friend', '0'),
(244, 'auto_friend_users', '[]'),
(245, 'auto_follow', '0'),
(246, 'auto_follow_users', ''),
(247, 'auto_like', '0'),
(248, 'auto_like_pages', ''),
(249, 'auto_join', '0'),
(250, 'auto_join_groups', ''),
(251, 'last_backup_time', ''),
(252, 'sms_provider', 'twilio'),
(253, 'bulksms_username', ''),
(254, 'bulksms_password', ''),
(255, 'infobip_username', ''),
(256, 'infobip_password', ''),
(257, 'watermark_enabled', '0'),
(258, 'watermark_icon', ''),
(259, 'watermark_position', 'bottom right'),
(260, 'watermark_xoffset', '-30'),
(261, 'watermark_yoffset', '-30'),
(262, 'watermark_opacity', '1'),
(263, 'adult_images_enabled', ''),
(264, 'adult_images_action', 'blur'),
(265, 'adult_images_api_key', ''),
(266, 'mobile_infinite_scroll', '0'),
(267, 'limit_cover_photo', '1'),
(268, 'comments_photos_enabled', '1'),
(269, 'chat_photos_enabled', '1'),
(270, 'onesignal_notification_enabled', '0'),
(271, 'onesignal_app_id', ''),
(272, 'onesignal_api_key', ''),
(273, 'system_distance', 'kilometer'),
(274, 'wallet_enabled', '0'),
(275, 'wallet_transfer_enabled', '1'),
(276, 'affiliates_money_withdraw_enabled', '1'),
(277, 'affiliates_money_transfer_enabled', '0'),
(278, 'pages_permission', 'everyone'),
(279, 'groups_permission', 'everyone'),
(280, 'events_permission', 'everyone'),
(281, 'blogs_permission', 'everyone'),
(282, 'market_permission', 'everyone'),
(283, 'forums_permission', 'everyone'),
(284, 'movies_permission', 'everyone'),
(285, 'games_permission', 'everyone'),
(286, 'jobs_enabled', '1'),
(287, 'posts_online_status', '1'),
(288, 'anonymous_mode', '1'),
(289, 'tinymce_photos_enabled', '1'),
(290, 'voice_notes_posts_enabled', '1'),
(291, 'voice_notes_comments_enabled', '1'),
(292, 'voice_notes_chat_enabled', '1'),
(293, 'offers_enabled', '1'),
(294, 'live_enabled', '0'),
(295, 'save_live_enabled', '0'),
(296, 'live_permission', 'everyone'),
(297, 'agora_app_id', ''),
(298, 'agora_app_certificate', ''),
(299, 'agora_customer_id', ''),
(300, 'agora_customer_certificate', ''),
(301, 'agora_s3_bucket', ''),
(302, 'agora_s3_region', 'us-east-1'),
(303, 'agora_s3_key', ''),
(304, 'agora_s3_secret', ''),
(305, 'chat_permanently_delete_enabled', '1'),
(306, 'system_description_directory', 'Discover new people, create new connections and make new friends'),
(307, 'system_description_offers', 'Discover new offers'),
(308, 'system_description_jobs', 'Discover new jobs offers'),
(309, 'system_description_blogs', 'Explore the latest articles'),
(310, 'system_description_marketplace', 'Discover new products'),
(311, 'system_description_forums', 'The great place to discuss topics with other users'),
(312, 'system_description_movies', 'Discover new movies'),
(313, 'stories_duration', '3'),
(314, 'desktop_infinite_scroll', '1'),
(315, 'disable_declined_friendrequest', '0'),
(316, 'wallet_withdrawal_enabled', '1'),
(317, 'wallet_payment_method', 'paypal,skrill'),
(318, 'wallet_payment_method_custom', ''),
(319, 'wallet_min_withdrawal', '50'),
(320, 'location_finder_enabled', '0'),
(321, 'relationship_info_enabled', '1'),
(322, 'website_info_enabled', '1'),
(323, 'biography_info_enabled', '1'),
(324, 'work_info_enabled', '1'),
(325, 'education_info_enabled', '1'),
(326, 'social_info_enabled', '1'),
(327, 'location_info_enabled', '1'),
(328, 'show_usernames_enabled', '0'),
(329, 'msg91_authkey', ''),
(330, 'name_min_length', '3'),
(331, 'newsfeed_source', 'default'),
(332, 'video_call_permission', 'everyone'),
(333, 'audio_call_permission', 'everyone'),
(334, 'funding_enabled', '0'),
(335, 'funding_permission', 'everyone'),
(336, 'system_description_funding', 'Discover new funding requests'),
(337, 'stories_permission', 'everyone'),
(338, 'ads_permission', 'everyone'),
(339, 'paystack_enabled', '0'),
(340, 'paystack_secret', ''),
(341, 'funding_money_withdraw_enabled', '1'),
(342, 'funding_payment_method', 'paypal,skrill'),
(343, 'funding_payment_method_custom', ''),
(344, 'funding_min_withdrawal', '50'),
(345, 'funding_money_transfer_enabled', '0'),
(346, 'funding_commission', '10'),
(347, 'play_store_badge_enabled', '0'),
(348, 'play_store_link', ''),
(349, 'app_store_badge_enabled', '0'),
(350, 'app_store_link', ''),
(351, 'invitation_permission', 'everyone'),
(352, 'invitation_user_limit', '5'),
(353, 'invitation_expire_period', 'month'),
(354, 'invitation_send_method', 'email'),
(355, 'appgallery_badge_enabled', '0'),
(356, 'appgallery_store_link', '');

-- --------------------------------------------------------

--
-- Table structure for table `system_themes`
--

DROP TABLE IF EXISTS `system_themes`;
CREATE TABLE IF NOT EXISTS `system_themes` (
  `theme_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL,
  `default` enum('0','1') NOT NULL,
  `enabled` enum('0','1') NOT NULL,
  PRIMARY KEY (`theme_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `system_themes`
--

INSERT INTO `system_themes` (`theme_id`, `name`, `default`, `enabled`) VALUES
(1, 'default', '1', '0');

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
CREATE TABLE IF NOT EXISTS `users` (
  `user_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_group` tinyint(10) UNSIGNED NOT NULL DEFAULT '3',
  `user_demo` enum('0','1') NOT NULL DEFAULT '0',
  `user_name` varchar(64) NOT NULL,
  `user_email` varchar(64) NOT NULL,
  `user_email_verified` enum('0','1') NOT NULL DEFAULT '0',
  `user_email_verification_code` varchar(64) DEFAULT NULL,
  `user_phone` varchar(64) DEFAULT NULL,
  `user_phone_verified` enum('0','1') NOT NULL DEFAULT '0',
  `user_phone_verification_code` varchar(64) DEFAULT NULL,
  `user_password` varchar(64) NOT NULL,
  `user_two_factor_enabled` enum('0','1') NOT NULL DEFAULT '0',
  `user_two_factor_type` enum('email','sms','google') DEFAULT NULL,
  `user_two_factor_key` varchar(64) DEFAULT NULL,
  `user_two_factor_gsecret` varchar(64) DEFAULT NULL,
  `user_activated` enum('0','1') NOT NULL DEFAULT '0',
  `user_reseted` enum('0','1') NOT NULL DEFAULT '0',
  `user_reset_key` varchar(64) DEFAULT NULL,
  `user_subscribed` enum('0','1') NOT NULL DEFAULT '0',
  `user_package` int(10) UNSIGNED DEFAULT NULL,
  `user_subscription_date` datetime DEFAULT NULL,
  `user_boosted_posts` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `user_boosted_pages` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `user_started` enum('0','1') NOT NULL DEFAULT '0',
  `user_verified` enum('0','1') NOT NULL DEFAULT '0',
  `user_banned` enum('0','1') NOT NULL DEFAULT '0',
  `user_live_requests_counter` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `user_live_requests_lastid` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `user_live_messages_counter` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `user_live_messages_lastid` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `user_live_notifications_counter` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `user_live_notifications_lastid` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `user_latitude` varchar(256) NOT NULL DEFAULT '0',
  `user_longitude` varchar(256) NOT NULL DEFAULT '0',
  `user_location_updated` datetime DEFAULT NULL,
  `user_firstname` varchar(256) NOT NULL,
  `user_lastname` varchar(256) DEFAULT NULL,
  `user_gender` int(10) UNSIGNED DEFAULT NULL,
  `user_picture` varchar(255) DEFAULT NULL,
  `user_picture_id` int(10) UNSIGNED DEFAULT NULL,
  `user_cover` varchar(256) DEFAULT NULL,
  `user_cover_id` int(10) UNSIGNED DEFAULT NULL,
  `user_cover_position` varchar(256) DEFAULT NULL,
  `user_album_pictures` int(10) UNSIGNED DEFAULT NULL,
  `user_album_covers` int(10) UNSIGNED DEFAULT NULL,
  `user_album_timeline` int(10) UNSIGNED DEFAULT NULL,
  `user_pinned_post` int(10) UNSIGNED DEFAULT NULL,
  `user_registered` datetime DEFAULT NULL,
  `user_last_seen` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `user_first_failed_login` datetime DEFAULT NULL,
  `user_failed_login_ip` varchar(64) DEFAULT NULL,
  `user_failed_login_count` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `user_country` int(10) UNSIGNED DEFAULT NULL,
  `user_birthdate` date DEFAULT NULL,
  `user_relationship` varchar(256) DEFAULT NULL,
  `user_biography` text,
  `user_website` varchar(256) DEFAULT NULL,
  `user_work_title` varchar(256) DEFAULT NULL,
  `user_work_place` varchar(256) DEFAULT NULL,
  `user_work_url` varchar(256) DEFAULT NULL,
  `user_current_city` varchar(256) DEFAULT NULL,
  `user_hometown` varchar(256) DEFAULT NULL,
  `user_edu_major` varchar(256) DEFAULT NULL,
  `user_edu_school` varchar(256) DEFAULT NULL,
  `user_edu_class` varchar(256) DEFAULT NULL,
  `user_social_facebook` varchar(256) DEFAULT NULL,
  `user_social_twitter` varchar(256) DEFAULT NULL,
  `user_social_youtube` varchar(256) DEFAULT NULL,
  `user_social_instagram` varchar(256) DEFAULT NULL,
  `user_social_linkedin` varchar(256) DEFAULT NULL,
  `user_social_vkontakte` varchar(256) DEFAULT NULL,
  `user_profile_background` varchar(256) DEFAULT NULL,
  `user_chat_enabled` enum('0','1') NOT NULL DEFAULT '1',
  `user_privacy_newsletter` enum('0','1') NOT NULL DEFAULT '1',
  `user_privacy_poke` enum('me','friends','public') NOT NULL DEFAULT 'public',
  `user_privacy_gifts` enum('me','friends','public') NOT NULL DEFAULT 'public',
  `user_privacy_wall` enum('me','friends','public') NOT NULL DEFAULT 'friends',
  `user_privacy_gender` enum('me','friends','public') NOT NULL DEFAULT 'public',
  `user_privacy_birthdate` enum('me','friends','public') NOT NULL DEFAULT 'public',
  `user_privacy_relationship` enum('me','friends','public') NOT NULL DEFAULT 'public',
  `user_privacy_basic` enum('me','friends','public') NOT NULL DEFAULT 'public',
  `user_privacy_work` enum('me','friends','public') NOT NULL DEFAULT 'public',
  `user_privacy_location` enum('me','friends','public') NOT NULL DEFAULT 'public',
  `user_privacy_education` enum('me','friends','public') NOT NULL DEFAULT 'public',
  `user_privacy_other` enum('me','friends','public') NOT NULL DEFAULT 'public',
  `user_privacy_friends` enum('me','friends','public') NOT NULL DEFAULT 'public',
  `user_privacy_photos` enum('me','friends','public') NOT NULL DEFAULT 'public',
  `user_privacy_pages` enum('me','friends','public') NOT NULL DEFAULT 'public',
  `user_privacy_groups` enum('me','friends','public') NOT NULL DEFAULT 'public',
  `user_privacy_events` enum('me','friends','public') NOT NULL DEFAULT 'public',
  `email_post_likes` enum('0','1') NOT NULL DEFAULT '1',
  `email_post_comments` enum('0','1') NOT NULL DEFAULT '1',
  `email_post_shares` enum('0','1') NOT NULL DEFAULT '1',
  `email_wall_posts` enum('0','1') NOT NULL DEFAULT '1',
  `email_mentions` enum('0','1') NOT NULL DEFAULT '1',
  `email_profile_visits` enum('0','1') NOT NULL DEFAULT '1',
  `email_friend_requests` enum('0','1') NOT NULL DEFAULT '1',
  `facebook_connected` enum('0','1') NOT NULL DEFAULT '0',
  `facebook_id` varchar(128) DEFAULT NULL,
  `google_connected` enum('0','1') NOT NULL DEFAULT '0',
  `google_id` varchar(128) DEFAULT NULL,
  `twitter_connected` enum('0','1') NOT NULL DEFAULT '0',
  `twitter_id` varchar(128) DEFAULT NULL,
  `instagram_connected` enum('0','1') NOT NULL DEFAULT '0',
  `instagram_id` varchar(128) DEFAULT NULL,
  `linkedin_connected` enum('0','1') NOT NULL DEFAULT '0',
  `linkedin_id` varchar(128) DEFAULT NULL,
  `vkontakte_connected` enum('0','1') NOT NULL DEFAULT '0',
  `vkontakte_id` varchar(128) DEFAULT NULL,
  `user_referrer_id` int(10) DEFAULT NULL,
  `user_affiliate_balance` float NOT NULL DEFAULT '0',
  `user_funding_balance` float NOT NULL DEFAULT '0',
  `user_wallet_balance` float NOT NULL DEFAULT '0',
  `user_points` int(10) NOT NULL DEFAULT '0',
  `chat_sound` enum('0','1') NOT NULL DEFAULT '1',
  `notifications_sound` enum('0','1') NOT NULL DEFAULT '1',
  `onesignal_user_id` varchar(100) DEFAULT NULL,
  `user_language` varchar(16) DEFAULT 'en_us',
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `username` (`user_name`),
  UNIQUE KEY `user_email` (`user_email`),
  UNIQUE KEY `facebook_id` (`facebook_id`),
  UNIQUE KEY `twitter_id` (`twitter_id`),
  UNIQUE KEY `linkedin_id` (`linkedin_id`),
  UNIQUE KEY `vkontakte_id` (`vkontakte_id`),
  UNIQUE KEY `instagram_id` (`instagram_id`),
  UNIQUE KEY `user_phone` (`user_phone`),
  UNIQUE KEY `google_id` (`google_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `users_blocks`
--

DROP TABLE IF EXISTS `users_blocks`;
CREATE TABLE IF NOT EXISTS `users_blocks` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` int(10) UNSIGNED NOT NULL,
  `blocked_id` int(10) UNSIGNED NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id_blocked_id` (`user_id`,`blocked_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `users_gifts`
--

DROP TABLE IF EXISTS `users_gifts`;
CREATE TABLE IF NOT EXISTS `users_gifts` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `from_user_id` int(10) UNSIGNED NOT NULL,
  `to_user_id` int(10) UNSIGNED NOT NULL,
  `gift_id` int(10) UNSIGNED NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `users_invitations`
--

DROP TABLE IF EXISTS `users_invitations`;
CREATE TABLE IF NOT EXISTS `users_invitations` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` int(10) UNSIGNED NOT NULL,
  `email_phone` varchar(64) NOT NULL,
  `invitation_date` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id_email_phone` (`user_id`,`email_phone`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `users_invitations`
--

INSERT INTO `users_invitations` (`id`, `user_id`, `email_phone`, `invitation_date`) VALUES
(1, 1, 'iyehiaabed@gmail.com', '2021-08-09 23:31:50');

-- --------------------------------------------------------

--
-- Table structure for table `users_pokes`
--

DROP TABLE IF EXISTS `users_pokes`;
CREATE TABLE IF NOT EXISTS `users_pokes` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` int(10) UNSIGNED NOT NULL,
  `poked_id` int(10) UNSIGNED NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id_blocked_id` (`user_id`,`poked_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `users_searches`
--

DROP TABLE IF EXISTS `users_searches`;
CREATE TABLE IF NOT EXISTS `users_searches` (
  `log_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` int(10) UNSIGNED NOT NULL,
  `node_id` int(10) UNSIGNED NOT NULL,
  `node_type` varchar(32) NOT NULL,
  `time` datetime DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  UNIQUE KEY `node_id_node_type` (`node_id`,`node_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `users_sessions`
--

DROP TABLE IF EXISTS `users_sessions`;
CREATE TABLE IF NOT EXISTS `users_sessions` (
  `session_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `session_token` varchar(64) NOT NULL,
  `session_date` datetime NOT NULL,
  `user_id` int(10) UNSIGNED NOT NULL,
  `user_browser` varchar(64) NOT NULL,
  `user_os` varchar(64) NOT NULL,
  `user_ip` varchar(64) NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_token` (`session_token`),
  KEY `user_ip` (`user_ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `verification_requests`
--

DROP TABLE IF EXISTS `verification_requests`;
CREATE TABLE IF NOT EXISTS `verification_requests` (
  `request_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `node_id` int(10) UNSIGNED NOT NULL,
  `node_type` varchar(32) NOT NULL,
  `photo` varchar(256) DEFAULT NULL,
  `passport` varchar(256) DEFAULT NULL,
  `message` text,
  `time` datetime NOT NULL,
  `status` tinyint(1) NOT NULL,
  PRIMARY KEY (`request_id`),
  UNIQUE KEY `node_id_node_type` (`node_id`,`node_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `wallet_payments`
--

DROP TABLE IF EXISTS `wallet_payments`;
CREATE TABLE IF NOT EXISTS `wallet_payments` (
  `payment_id` int(10) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) UNSIGNED NOT NULL,
  `amount` varchar(32) NOT NULL,
  `method` varchar(64) NOT NULL,
  `method_value` text NOT NULL,
  `time` datetime NOT NULL,
  `status` tinyint(1) NOT NULL,
  PRIMARY KEY (`payment_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `wallet_transactions`
--

DROP TABLE IF EXISTS `wallet_transactions`;
CREATE TABLE IF NOT EXISTS `wallet_transactions` (
  `transaction_id` int(10) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) UNSIGNED NOT NULL,
  `node_type` varchar(32) NOT NULL,
  `node_id` int(10) UNSIGNED DEFAULT NULL,
  `amount` varchar(32) NOT NULL,
  `type` enum('in','out') NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `widgets`
--

DROP TABLE IF EXISTS `widgets`;
CREATE TABLE IF NOT EXISTS `widgets` (
  `widget_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `title` varchar(256) NOT NULL,
  `place` varchar(32) NOT NULL,
  `place_order` int(10) UNSIGNED NOT NULL DEFAULT '1',
  `code` mediumtext NOT NULL,
  PRIMARY KEY (`widget_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

    ";
    $db->multi_query($structure) or _error("Error", $db->error);
    

    // flush multi_queries
    do{} while(mysqli_more_results($db) && mysqli_next_result($db));


    // update system settings
    update_system_options([ 
        'system_email' => secure($_POST['admin_email']), 
        'session_hash' => secure($session_hash)
    ], false);


    // add the admin account
    $db->query(sprintf("INSERT INTO users (user_group, user_email, user_name, user_firstname, user_password, user_gender, user_email_verified, user_activated, user_verified, user_started, user_registered) VALUES ('1', %s, %s, %s, %s, '1', '1', '1', '1', '1', %s)", secure($_POST['admin_email']), secure($_POST['admin_username']), secure($_POST['admin_username']), secure(_password_hash($_POST['admin_password'])), secure(gmdate('Y-m-d H:i:s')) )) or _error("Error", $db->error);


    // create config file
    $config_string = '<?php  
    define("DB_NAME", \''. $_POST["db_name"]. '\');
    define("DB_USER", \''. $_POST["db_username"]. '\');
    define("DB_PASSWORD", \''. $_POST["db_password"]. '\');
    define("DB_HOST", \''. $_POST["db_host"]. '\');
    define("DB_PORT", \''. $_POST["db_port"]. '\');
    define("SYS_URL", \''. get_system_url(). '\');
    define("DEBUGGING", false);
    define("DEFAULT_LOCALE", \'en_us\');
    define("LICENCE_KEY", \''. $licence_key. '\');
    ?>';
    $config_file = 'includes/config.php';
    $handle = fopen($config_file, 'w') or _error("Error", "Intsaller wizard cannot create the config file");
    fwrite($handle, $config_string);
    fclose($handle);
    

    // start the system
    header('Location: ./');
}

?>

<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta http-equiv="X-UA-Compatible" content="ie=edge">
        <title><?php echo SYS_NAME ?> &rsaquo; Installer (v<?php echo SYS_VER ?>)</title>
        <link rel="shortcut icon" href="includes/assets/js/core/installer/favicon.png" />
        <link href="https://fonts.googleapis.com/css?family=Karla:400,700&display=swap" rel="stylesheet" crossorigin="anonymous">
        <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.14.0/css/all.css" crossorigin="anonymous">
        <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" integrity="sha384-JcKb8q3iqJ61gNV9KGb8thSsNjpSL0n8PARn9HuZOnIxN0hoP+VmmDGMN5t9UJ0Z" crossorigin="anonymous">
        <link rel="stylesheet" href="includes/assets/js/core/installer/wizard.css">
    </head>
    <body>
        <main class="my-5">
            <div class="container">
                <form id="wizard" method="post" class="position-relative">
                    <!-- Step 1 -->
                    <h3>
                        <div class="media">
                            <div class="bd-wizard-step-icon"><i class="fas fa-file-alt"></i></div>
                            <div class="media-body">
                                <div class="bd-wizard-step-title">License</div>
                                <div class="bd-wizard-step-subtitle">Step 1</div>
                            </div>
                        </div>
                    </h3>
                    <section>
                        <div class="content-wrapper">
                            <h3 class="section-heading">Welcome!</h3>
                            <p>
                                Welcome to <strong><?php echo SYS_NAME ?></strong> installation process! Just fill in the required
                                information and create your own social website or online community.
                            </p>
                            <h6 class="mt-4">
                                <strong>LICENSE AGREEMENT:</strong>
                            </h6>
                            <div>
                                <strong>You CAN:</strong>
                                <ol>
                                    <li>Install on one (1) end-product (domain.com, sub.domain.com or domain.com/directory).
                                    </li>
                                    <li>Install on your localhost server for testing or development.</li>
                                    <li>Edit the source code and design as you want to suit your business needs.</li>
                                </ol>
                            </div>
                            <div>
                                <strong>You CANNOT:</strong>
                                <ol>
                                    <li>Run it on (2) or more end-prodcuts at same time with same license.</li>
                                    <li>Resell, distribute, give away or trade by any means to any third party or individuals.
                                    </li>
                                </ol>
                            </div>
                            <div class="form-check mt-5">
                                <input type="checkbox" class="form-check-input" id="license-checkbox">
                                <label class="form-check-label" for="license-checkbox">I agree with the Terms and
                                Conditions.</label>
                                <div class="invalid-feedback">
                                    You must agree to continue.
                                </div>
                            </div>
                        </div>
                    </section>
                    <!-- Step 1 -->
                    <!-- Step 2 -->
                    <h3>
                        <div class="media">
                            <div class="bd-wizard-step-icon"><i class="fas fa-server"></i></div>
                            <div class="media-body">
                                <div class="bd-wizard-step-title">Requirements</div>
                                <div class="bd-wizard-step-subtitle">Step 2</div>
                            </div>
                        </div>
                    </h3>
                    <section>
                        <div class="content-wrapper">
                            <input type="hidden" id="requirements_errors" <?php if($requirements_errors) { ?>value="true"
                                <?php } else { ?>value="false" <?php } ?>>
                            <div id="requirements_alert" class="alert alert-danger" style="display: none;">
                                <strong>Sorry!</strong> You need to check the system requirements to continue, Back to your
                                hosting support for help.
                            </div>
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Name</th>
                                        <th>Description</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>PHP 5.5+</td>
                                        <td>Required PHP version 5.5 or more</td>
                                        <td>
                                            <?php if($requirements_errors['PHP']) { ?>
                                            <font color="red"><i class="fas fa-times-circle"></i> Not Installed</font>
                                            <?php } else { ?>
                                            <font color="green"><i class="fas fa-check-circle"></i> Installed</font>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>MySQLi</td>
                                        <td>Required MySQLi PHP extension</td>
                                        <td>
                                            <?php if($requirements_errors['mysqli']) { ?>
                                            <font color="red"><i class="fas fa-times-circle"></i> Not Installed</font>
                                            <?php } else { ?>
                                            <font color="green"><i class="fas fa-check-circle"></i> Installed</font>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>cURL</td>
                                        <td>Required cURL PHP extension</td>
                                        <td>
                                            <?php if($requirements_errors['curl']) { ?>
                                            <font color="red"><i class="fas fa-times-circle"></i> Not Installed</font>
                                            <?php } else { ?>
                                            <font color="green"><i class="fas fa-check-circle"></i> Installed</font>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Mbstring</td>
                                        <td>Required Mbstring extension for UTF-8 strings</td>
                                        <td>
                                            <?php if($requirements_errors['mbstring']) { ?>
                                            <font color="red"><i class="fas fa-times-circle"></i> Not Installed</font>
                                            <?php } else { ?>
                                            <font color="green"><i class="fas fa-check-circle"></i> Installed</font>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>GD Library</td>
                                        <td>Required GD Library to handle images</td>
                                        <td>
                                            <?php if($requirements_errors['gd']) { ?>
                                            <font color="red"><i class="fas fa-times-circle"></i> Not Installed</font>
                                            <?php } else { ?>
                                            <font color="green"><i class="fas fa-check-circle"></i> Installed</font>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>ZIP</td>
                                        <td>Required ZIP extension for taking backup</td>
                                        <td>
                                            <?php if($requirements_errors['zip']) { ?>
                                            <font color="red"><i class="fas fa-times-circle"></i> Not Installed</font>
                                            <?php } else { ?>
                                            <font color="green"><i class="fas fa-check-circle"></i> Installed</font>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>allow_url_fopen</td>
                                        <td>Required allow_url_fopen</td>
                                        <td>
                                            <?php if($requirements_errors['allow_url_fopen']) { ?>
                                            <font color="red"><i class="fas fa-times-circle"></i> Not Installed</font>
                                            <?php } else { ?>
                                            <font color="green"><i class="fas fa-check-circle"></i> Installed</font>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>.htaccess</td>
                                        <td>Required .htaccess file for links <small><strong>(Located in ./Script)</strong></small>
                                        </td>
                                        <td>
                                            <?php if($requirements_errors['htaccess']) { ?>
                                            <font color="red"><i class="fas fa-times-circle"></i> Not Installed</font>
                                            <?php } else { ?>
                                            <font color="green"><i class="fas fa-check-circle"></i> Installed</font>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>config.php</td>
                                        <td>Required <strong>includes</strong> folder to be writable for the installation</td>
                                        <td>
                                            <?php if($requirements_errors['config']) { ?>
                                            <font color="red"><i class="fas fa-times-circle"></i> Not Installed</font>
                                            <?php } else { ?>
                                            <font color="green"><i class="fas fa-check-circle"></i> Installed</font>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </section>
                    <!-- Step 2 -->
                    <!-- Step 3 -->
                    <h3>
                        <div class="media">
                            <div class="bd-wizard-step-icon"><i class="fas fa-cubes"></i></div>
                            <div class="media-body">
                                <div class="bd-wizard-step-title">Installation</div>
                                <div class="bd-wizard-step-subtitle">Step 3</div>
                            </div>
                        </div>
                    </h3>
                    <section>
                        <div class="content-wrapper">
                            <h4 class="section-heading">License Details</h4>
                            <div class="row">
                                <div class="form-group col-12">
                                    <label for="purchase_code">Your Purchase Code</label>
                                    <input type="text" name="purchase_code" id="purchase_code" class="form-control"
                                        placeholder="xxx-xx-xxxx">
                                    <div class="invalid-feedback">
                                        This field can't be empty
                                    </div>
                                </div>
                            </div>
                            <h4 class="section-heading mt-4">Database Details</h4>
                            <div class="row">
                                <div class="form-group col-12">
                                    <label for="db_name">Database Name</label>
                                    <input type="text" name="db_name" id="db_name" class="form-control">
                                    <div class="invalid-feedback">
                                        This field can't be empty
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="form-group col-md-6">
                                    <label for="db_username">Database Username</label>
                                    <input type="text" name="db_username" id="db_username" class="form-control">
                                    <div class="invalid-feedback">
                                        This field can't be empty
                                    </div>
                                </div>
                                <div class="form-group col-md-6">
                                    <label for="db_password">Database Password</label>
                                    <input type="text" name="db_password" id="db_password" class="form-control">
                                </div>
                            </div>
                            <div class="row">
                                <div class="form-group col-md-6">
                                    <label for="db_host">Database Host</label>
                                    <input type="text" name="db_host" id="db_host" class="form-control" value="localhost">
                                    <div class="invalid-feedback">
                                        This field can't be empty
                                    </div>
                                </div>
                                <div class="form-group col-md-6">
                                    <label for="db_port">Database Port</label>
                                    <input type="text" name="db_port" id="db_port" class="form-control" value="3306">
                                    <div class="invalid-feedback">
                                        This field can't be empty
                                    </div>
                                </div>
                            </div>
                            <h4 class="section-heading mt-4">Admin Details</h4>
                            <div class="row">
                                <div class="form-group col-12">
                                    <label for="admin_email">Admin Email</label>
                                    <input type="text" name="admin_email" id="admin_email" class="form-control">
                                    <div class="invalid-feedback">
                                        This field can't be empty
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="form-group col-md-6">
                                    <label for="admin_username">Admin Username</label>
                                    <input type="text" name="admin_username" id="admin_username" class="form-control">
                                    <div class="invalid-feedback">
                                        This field can't be empty
                                    </div>
                                </div>
                                <div class="form-group col-md-6">
                                    <label for="admin_password">Admin Password</label>
                                    <input type="text" name="admin_password" id="admin_password" class="form-control">
                                    <div class="invalid-feedback">
                                        This field can't be empty
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>
                    <!-- Step 3 -->
                    <!-- Step 4 -->
                    <h3>
                        <div class="media">
                            <div class="bd-wizard-step-icon"><i class="fas fa-flag-checkered"></i></div>
                            <div class="media-body">
                                <div class="bd-wizard-step-title">Finish</div>
                                <div class="bd-wizard-step-subtitle">Step 4</div>
                            </div>
                        </div>
                    </h3>
                    <section>
                        <div class="content-wrapper">
                            <h4 class="section-heading mb-5">Review Your Details</h4>
                            <h6 class="font-weight-bold">License Details</h6>
                            <p class="mb-4">
                                <strong>Purchase Code:</strong> <span id="entered_purchase_code"></span>
                            </p>
                            <h6 class="font-weight-bold">Database Details</h6>
                            <p class="mb-4">
                                <strong>Name:</strong> <span id="entered_db_name"></span> <br>
                                <strong>Username:</strong> <span id="entered_db_username"></span> <br>
                                <strong>Password:</strong> <span id="entered_db_password"></span> <br>
                                <strong>Host:</strong> <span id="entered_db_host"></span> <br>
                                <strong>Port:</strong> <span id="entered_db_port"></span>
                            </p>
                            <h6 class="font-weight-bold">Admin Details</h6>
                            <p class="mb-4">
                                <strong>Email:</strong> <span id="entered_admin_email"></span> <br>
                                <strong>Username:</strong> <span id="entered_admin_username"></span> <br>
                                <strong>Password:</strong> <span id="entered_admin_password"></span>
                            </p>
                        </div>
                    </section>
                    <!-- Step 4 -->
                    <!-- Submit -->
                    <div style="display: none;">
                        <button class="btn btn-primary" name="submit" type="submit" id="wizard-submittion">Submit</button>
                    </div>
                    <!-- Submit -->
                    <!-- Loader -->
                    <div id="loader" style="display: none;">
                        <div class="wizard-loader">
                            Installing<span class="spinner-grow spinner-grow-sm ml-3"></span>
                        </div>
                    </div>
                    <!-- Loader -->
                </form>
            </div>
        </main>
        <script src="https://code.jquery.com/jquery-3.5.1.min.js" integrity="sha256-9/aliU8dGd2tb6OSsuzixeV4y/faTqgFtohetphbbj0=" crossorigin="anonymous"></script>
        <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js" integrity="sha384-9/reFTGAW83EW2RDu2S0VKaIzap3H66lZH81PoYlFhbGU+6BZp6G7niu735Sk7lN" crossorigin="anonymous"></script>
        <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js" integrity="sha384-B4gt1jrGC7Jh4AgTPSdUtOBvfO8shuf57BaghqFfPlYxofvL8/KUEfYiJOMMV+rV" crossorigin="anonymous"></script>
        <script src="includes/assets/js/core/installer/jquery.steps.min.js"></script>
        <script type="text/javascript">
            // handle wizard
            var wizard = $("#wizard");
            wizard.steps({
                headerTag: "h3",
                bodyTag: "section",
                transitionEffect: "none",
                titleTemplate: '#title#',
                onStepChanging: function (event, currentIndex, newIndex) {
                    /* allow previous action even if the current form is not valid! */
                    if (currentIndex > newIndex) {
                        return true;
                    }
                    /* check license agreement */
                    if (currentIndex == 0) {
                        if (!wizard.find("#license-checkbox").is(':checked')) {
                            wizard.find("#license-checkbox").addClass("is-invalid");
                            return false;
                        }
                    }
                    /* check requirements errors */
                    if (currentIndex == 1) {
                        if ($('#requirements_errors').val() == "true") {
                            $('#requirements_alert').slideDown()
                            return false;
                        }
                    }
                    /* check details */
                    if (currentIndex == 2) {
                        var errors = 0;
                        $('input[type="text"]').each(function () {
                            if ($(this).attr("name") !== "db_password" && $(this).val() == "") {
                                $(this).addClass("is-invalid");
                                errors++;
                            }
                        });
                        if (errors >= 1) {
                            return false;
                        }
                    }
                    return true;
                },
                onFinished: function (event, currentIndex) {
                    $("#loader").slideDown();
                    $("#wizard-submittion").click();
                    return true;
                },
                labels: {
                    finish: "Install",
                }
            });
            
            // handle checkbox
            $('#license-checkbox').on('change', function () {
                if ($(this).is(':checked')) {
                    $(this).removeClass("is-invalid");
                } else {
                    $(this).addClass("is-invalid");
                }
            });
            
            // handle inputs
            $('input[type="text"]').on('change', function () {
                if ($(this).attr("name") !== "db_password") {
                    if ($(this).val() == "") {
                        $(this).addClass("is-invalid");
                    } else {
                        $(this).removeClass("is-invalid");
                    }
                }
            });
            $(document).ready(function () {
                $('input[type="text"]').each(function () {
                    $('#entered_' + $(this).attr("id")).text($(this).val());
                });
            });
            $('input[type="text"]').on('change', function () {
                $('#entered_' + $(this).attr("id")).text($(this).val());
            });
        </script>
    </body>
</html>